/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.network;

import alexthw.not_enough_glyphs.common.network.NetworkUtil;
import alexthw.not_enough_glyphs.init.NotEnoughGlyphs;
import com.hollingsworth.arsnouveau.api.registry.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PacketRayEffect
extends AbstractPacket {
    public Vec3 from;
    public Vec3 to;
    public ParticleColor colors;
    public static final CustomPacketPayload.Type<PacketRayEffect> TYPE = new CustomPacketPayload.Type(NotEnoughGlyphs.prefix("ray_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketRayEffect> CODEC = StreamCodec.ofMember(PacketRayEffect::toBytes, PacketRayEffect::new);

    public PacketRayEffect(Vec3 from, Vec3 to, ParticleColor colors) {
        this.from = from;
        this.to = to;
        this.colors = colors;
    }

    public static void toBytes(PacketRayEffect msg, FriendlyByteBuf buf) {
        NetworkUtil.encodeVec3(buf, msg.from);
        NetworkUtil.encodeVec3(buf, msg.to);
        buf.writeNbt((Tag)msg.colors.serialize());
    }

    public PacketRayEffect(FriendlyByteBuf buf) {
        this(NetworkUtil.decodeVec3(buf), NetworkUtil.decodeVec3(buf), ParticleColorRegistry.from((CompoundTag)buf.readNbt()));
    }

    public void onClientReceived(Minecraft minecraft, Player player) {
        Level level = player.level();
        double distance = this.from.distanceTo(this.to);
        double start = 0.0;
        double increment = 0.0625;
        if (player.position().distanceToSqr(this.from) < 4.0 && this.to.subtract(this.from).normalize().dot(player.getViewVector(1.0f)) > (double)(Mth.SQRT_OF_TWO / 2.0f)) {
            start = Math.min(2.0, distance / 2.0);
            increment = 0.125;
        }
        for (double d = start; d < distance; d += increment) {
            double fractionalDistance = d / distance;
            double speedCoefficient = Mth.lerp((double)fractionalDistance, (double)0.2, (double)0.001);
            level.addParticle(GlowParticleData.createData((ParticleColor)this.colors), Mth.lerp((double)fractionalDistance, (double)this.from.x, (double)this.to.x), Mth.lerp((double)fractionalDistance, (double)this.from.y, (double)this.to.y), Mth.lerp((double)fractionalDistance, (double)this.from.z, (double)this.to.z), ((double)level.random.nextFloat() - 0.5) * speedCoefficient, ((double)level.random.nextFloat() - 0.5) * speedCoefficient, ((double)level.random.nextFloat() - 0.5) * speedCoefficient);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

