/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.propagators;

import alexthw.not_enough_glyphs.api.IPropagator;
import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropagateProjectile
extends AbstractEffect
implements IPropagator {
    public static final PropagateProjectile INSTANCE = new PropagateProjectile();

    public PropagateProjectile() {
        super(CompatRL.omega("propagate_projectile"), "Propagate Projectile");
    }

    public String getBookDescription() {
        return "Convert the remainder of the spell into a Projectile spell, shot from the hit point towards where the caster is looking.";
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        MethodProjectile.INSTANCE.addAugmentDescriptions(map);
    }

    @Override
    public void propagate(Level world, HitResult hitResult, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        int numSplits = 1 + stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        Vec3 pos = hitResult.getLocation();
        ArrayList<EntityProjectileSpell> projectiles = new ArrayList<EntityProjectileSpell>();
        for (int i = 0; i < numSplits; ++i) {
            projectiles.add(new EntityProjectileSpell(world, resolver));
        }
        float velocity = Math.max(0.1f, 0.75f + stats.getAccMultiplier() / 2.0f);
        int opposite = -1;
        int counter = 0;
        Vec3 direction = pos.subtract(shooter.position());
        IWrappedCaster iWrappedCaster = resolver.spellContext.getCaster();
        if (iWrappedCaster instanceof TileCaster) {
            TileCaster tc = (TileCaster)iWrappedCaster;
            BlockEntity blockEntity = tc.getTile();
            if (blockEntity instanceof RotatingTurretTile) {
                RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                direction = rotatingTurretTile.getShootAngle();
            } else {
                direction = new Vec3(((Direction)tc.getTile().getBlockState().getValue((Property)BasicSpellTurret.FACING)).step());
            }
        }
        for (EntityProjectileSpell proj : projectiles) {
            proj.setPos(pos.add(0.0, 1.0, 0.0));
            if (!(shooter instanceof FakePlayer)) {
                proj.shoot((Entity)shooter, shooter.getXRot(), shooter.getYRot() + (float)(Math.round((double)counter / 2.0) * 5L * (long)opposite), 0.0f, velocity, 0.8f);
            } else {
                proj.shoot(direction.x, direction.y, direction.z, velocity, 0.8f);
            }
            opposite *= -1;
            ++counter;
            world.addFreshEntity((Entity)proj);
        }
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public int getDefaultManaCost() {
        return 100;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return MethodProjectile.INSTANCE.getCompatibleAugments();
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public Integer getTypeIndex() {
        return 8;
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this, (AbstractSpellPart)this){

                @NotNull
                public String getCreatorModId(@NotNull ItemStack itemStack) {
                    return "not_enough_glyphs";
                }
            };
        }
        return this.glyphItem;
    }
}

