/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.sugar.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import nolijium.mixinextras.injector.StackExtension;
import nolijium.mixinextras.lib.apache.commons.tuple.Pair;
import nolijium.mixinextras.service.MixinExtrasService;
import nolijium.mixinextras.sugar.impl.SugarApplicationException;
import nolijium.mixinextras.sugar.impl.SugarApplicator;
import nolijium.mixinextras.sugar.impl.SugarParameter;
import nolijium.mixinextras.sugar.impl.SugarWrapper;
import nolijium.mixinextras.sugar.impl.handlers.HandlerInfo;
import nolijium.mixinextras.sugar.impl.handlers.HandlerTransformer;
import nolijium.mixinextras.utils.ASMUtils;
import nolijium.mixinextras.utils.MixinInternals;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;

class SugarInjector {
    private final InjectionInfo injectionInfo;
    private final IMixinInfo mixin;
    private final MethodNode handler;
    private final List sugarAnnotations;
    private final List parameterGenerics;
    private Map targets;
    private final List strippedSugars = new ArrayList();
    private final List applicators = new ArrayList();
    private final List exceptions = new ArrayList();

    SugarInjector(InjectionInfo injectionInfo, IMixinInfo iMixinInfo, MethodNode methodNode, List list, List list2) {
        this.injectionInfo = injectionInfo;
        this.mixin = iMixinInfo;
        this.handler = methodNode;
        this.sugarAnnotations = list;
        this.parameterGenerics = list2;
    }

    void setTargets(Map map) {
        this.targets = map;
    }

    static void prepareMixin(IMixinInfo iMixinInfo, ClassNode object) {
        for (MethodNode methodNode : ((ClassNode)object).methods) {
            if (!SugarInjector.hasSugar(methodNode)) continue;
            SugarInjector.wrapInjectorAnnotation(iMixinInfo, methodNode);
        }
    }

    static HandlerInfo getHandlerInfo(IMixinInfo iMixinInfo, MethodNode methodNode, List object, List iterator2) {
        ArrayList arrayList = new ArrayList();
        for (Iterator iterator2 : SugarInjector.findSugars(methodNode, (List)object, (List)((Object)iterator2))) {
            if ((iterator2 = HandlerTransformer.create(iMixinInfo, (SugarParameter)((Object)iterator2))) == null || !((HandlerTransformer)((Object)iterator2)).isRequired(methodNode)) continue;
            arrayList.add(iterator2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        object = new HandlerInfo();
        iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            ((HandlerTransformer)iterator2.next()).transform((HandlerInfo)object);
        }
        return object;
    }

    private static boolean hasSugar(MethodNode listArray) {
        listArray = listArray.invisibleParameterAnnotations;
        if (listArray.invisibleParameterAnnotations == null) {
            return false;
        }
        int n2 = listArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!SugarInjector.isSugar(listArray[i2])) continue;
            return true;
        }
        return false;
    }

    private static boolean isSugar(List object) {
        if (object == null) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (!SugarApplicator.isSugar(((AnnotationNode)object.next()).desc)) continue;
            return true;
        }
        return false;
    }

    private static void wrapInjectorAnnotation(IMixinInfo iMixinInfo, MethodNode methodNode) {
        if ((iMixinInfo = InjectionInfo.getInjectorAnnotation((IMixinInfo)iMixinInfo, (MethodNode)methodNode)) == null) {
            return;
        }
        List list = SugarInjector.stripSugarAnnotations(methodNode);
        Type type = Type.getType((String)iMixinInfo.desc);
        if (MixinExtrasService.getInstance().isClassOwned(type.getClassName()) && type.getInternalName().endsWith("WrapMethod")) {
            iMixinInfo.visit("sugars", (Object)list);
            return;
        }
        type = new AnnotationNode(Type.getDescriptor(SugarWrapper.class));
        type.visit("original", (Object)iMixinInfo);
        type.visit("signature", (Object)(methodNode.signature == null ? "" : methodNode.signature));
        type.visit("sugars", (Object)list);
        methodNode.visibleAnnotations.remove(iMixinInfo);
        methodNode.visibleAnnotations.add(type);
    }

    private static List stripSugarAnnotations(MethodNode listArray) {
        ArrayList<AnnotationNode> arrayList = new ArrayList<AnnotationNode>();
        listArray = listArray.invisibleParameterAnnotations;
        int n2 = listArray.invisibleParameterAnnotations.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            List list = listArray[i2];
            AnnotationNode annotationNode = SugarInjector.findSugar(list);
            if (annotationNode != null) {
                arrayList.add(annotationNode);
                list.remove(annotationNode);
                continue;
            }
            arrayList.add(new AnnotationNode(Type.getDescriptor(Deprecated.class)));
        }
        return arrayList;
    }

    void stripSugar() {
        this.strippedSugars.addAll(SugarInjector.findSugars(this.handler, this.sugarAnnotations, this.parameterGenerics));
        ArrayList<Type> arrayList = new ArrayList<Type>();
        boolean bl = false;
        int n2 = 0;
        for (Type type : Type.getArgumentTypes((String)this.handler.desc)) {
            if (!SugarApplicator.isSugar(((AnnotationNode)this.sugarAnnotations.get((int)n2)).desc)) {
                if (bl) {
                    throw new IllegalStateException(String.format("Found non-trailing sugared parameters on %s", this.handler.name + this.handler.desc));
                }
                arrayList.add(type);
            } else {
                bl = true;
            }
            ++n2;
        }
        this.handler.desc = Type.getMethodDescriptor((Type)Type.getReturnType((String)this.handler.desc), (Type[])arrayList.toArray(new Type[0]));
    }

    void prepareSugar() {
        this.makeApplicators();
        this.validateApplicators();
        this.prepareApplicators();
    }

    private void makeApplicators() {
        for (Object object : this.strippedSugars) {
            object = SugarApplicator.create(this.injectionInfo, (SugarParameter)object);
            this.applicators.add(object);
        }
    }

    private void validateApplicators() {
        for (SugarApplicator sugarApplicator : this.applicators) {
            for (Map.Entry entry : this.targets.entrySet()) {
                Target target = (Target)entry.getKey();
                ListIterator object = ((List)entry.getValue()).listIterator();
                while (object.hasNext()) {
                    InjectionNodes.InjectionNode injectionNode = (InjectionNodes.InjectionNode)object.next();
                    try {
                        sugarApplicator.validate(target, injectionNode);
                    }
                    catch (SugarApplicationException sugarApplicationException) {
                        this.exceptions.add(new SugarApplicationException(String.format("Failed to validate sugar %s %s on method %s from mixin %s in target method %s at instruction %s", ASMUtils.annotationToString(sugarApplicator.sugar), ASMUtils.typeToString(sugarApplicator.paramType), this.handler, this.mixin, target, injectionNode), (Throwable)((Object)sugarApplicationException)));
                        object.remove();
                    }
                }
            }
        }
    }

    private void prepareApplicators() {
        for (Map.Entry entry : this.targets.entrySet()) {
            Target target = (Target)entry.getKey();
            for (InjectionNodes.InjectionNode injectionNode : (List)entry.getValue()) {
                try {
                    Iterator exception = this.applicators.iterator();
                    while (exception.hasNext()) {
                        ((SugarApplicator)exception.next()).prepare(target, injectionNode);
                    }
                }
                catch (Exception exception) {
                    throw new SugarApplicationException(String.format("Failed to prepare sugar for method %s from mixin %s in target method %s at instruction %s", this.handler, this.mixin, target, injectionNode), exception);
                }
            }
        }
    }

    List getExceptions() {
        return this.exceptions;
    }

    void reSugarHandler() {
        ArrayList<Type> arrayList = new ArrayList<Type>(Arrays.asList(Type.getArgumentTypes((String)this.handler.desc)));
        for (SugarParameter sugarParameter : this.strippedSugars) {
            arrayList.add(sugarParameter.type);
        }
        this.handler.desc = Type.getMethodDescriptor((Type)Type.getReturnType((String)this.handler.desc), (Type[])arrayList.toArray(new Type[0]));
    }

    void transformHandlerCalls(Map object) {
        for (Map.Entry entry : object.entrySet()) {
            Target target = (Target)entry.getKey();
            StackExtension stackExtension = new StackExtension(target);
            for (Pair pair : (List)entry.getValue()) {
                Object exception = (InjectionNodes.InjectionNode)pair.getLeft();
                pair = (MethodInsnNode)pair.getRight();
                InjectionNodes.InjectionNode injectionNode = target.addInjectionNode((AbstractInsnNode)pair);
                for (Map.Entry entry2 : MixinInternals.getDecorations((InjectionNodes.InjectionNode)exception).entrySet()) {
                    if (!((String)entry2.getKey()).startsWith("mixinextras_persistent_")) continue;
                    injectionNode.decorate((String)entry2.getKey(), entry2.getValue());
                }
                try {
                    exception = this.applicators.iterator();
                    while (exception.hasNext()) {
                        ((SugarApplicator)exception.next()).inject(target, injectionNode, stackExtension);
                    }
                }
                catch (Exception exception2) {
                    throw new SugarApplicationException(String.format("Failed to apply sugar to method %s from mixin %s in target method %s at instruction %s", this.handler, this.mixin, target, injectionNode), exception2);
                }
                ((MethodInsnNode)pair).desc = this.handler.desc;
            }
        }
    }

    private static List findSugars(MethodNode methodNode, List list, List list2) {
        ArrayList<SugarParameter> arrayList = new ArrayList<SugarParameter>();
        Type[] typeArray = Type.getArgumentTypes((String)methodNode.desc);
        int n2 = 0;
        int n3 = Bytecode.isStatic((MethodNode)methodNode) ? 0 : 1;
        for (Type type : typeArray) {
            AnnotationNode annotationNode = (AnnotationNode)list.get(n2);
            if (SugarApplicator.isSugar(annotationNode.desc)) {
                arrayList.add(new SugarParameter(annotationNode, type, (Type)list2.get(n2), n3, n2));
            }
            ++n2;
            n3 += type.getSize();
        }
        return arrayList;
    }

    private static AnnotationNode findSugar(List list) {
        if (list == null) {
            return null;
        }
        AnnotationNode annotationNode = null;
        for (AnnotationNode annotationNode2 : list) {
            if (!SugarApplicator.isSugar(annotationNode2.desc)) continue;
            if (annotationNode != null) {
                throw new IllegalStateException("Found multiple sugars on the same parameter! Got " + list.stream().map(ASMUtils::annotationToString).collect(Collectors.joining(" ")));
            }
            annotationNode = annotationNode2;
        }
        return annotationNode;
    }

    private static List getParamAnnotations(MethodNode listArray, int n2) {
        listArray = listArray.invisibleParameterAnnotations;
        if (listArray.invisibleParameterAnnotations != null && listArray.length >= n2) {
            return listArray[n2];
        }
        return null;
    }
}

