/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.sugar.impl;

import java.util.HashMap;
import nolijium.mixinextras.injector.StackExtension;
import nolijium.mixinextras.sugar.impl.SugarApplicationException;
import nolijium.mixinextras.sugar.impl.SugarApplicator;
import nolijium.mixinextras.sugar.impl.SugarParameter;
import nolijium.mixinextras.sugar.impl.SugarPostProcessingExtension;
import nolijium.mixinextras.sugar.impl.ref.LocalRefClassGenerator;
import nolijium.mixinextras.sugar.impl.ref.LocalRefUtils;
import nolijium.mixinextras.utils.CompatibilityHelper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.modify.InvalidImplicitDiscriminatorException;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;

class LocalSugarApplicator
extends SugarApplicator {
    private final boolean isArgsOnly;
    private final Type targetLocalType;
    private final boolean isMutable;

    LocalSugarApplicator(InjectionInfo injectionInfo, SugarParameter sugarParameter) {
        super(injectionInfo, sugarParameter);
        this.targetLocalType = LocalRefUtils.getTargetType(this.paramType, this.paramGeneric);
        this.isMutable = this.targetLocalType != this.paramType;
        this.isArgsOnly = (Boolean)Annotations.getValue((AnnotationNode)this.sugar, (String)"argsOnly", (Object)Boolean.FALSE);
    }

    @Override
    void validate(Target target, InjectionNodes.InjectionNode injectionNode) {
        LocalVariableDiscriminator localVariableDiscriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.sugar);
        LocalVariableDiscriminator.Context context = this.getOrCreateLocalContext(target, injectionNode);
        if (localVariableDiscriminator.printLVT()) {
            this.printLocals(target, injectionNode.getCurrentTarget(), context, localVariableDiscriminator);
            this.info.addCallbackInvocation(this.info.getMethod());
            throw new SugarApplicationException("Application aborted because locals are being printed instead.");
        }
        try {
            if (localVariableDiscriminator.findLocal(context) < 0) {
                throw new SugarApplicationException("Unable to find matching local!");
            }
            return;
        }
        catch (InvalidImplicitDiscriminatorException invalidImplicitDiscriminatorException) {
            throw new SugarApplicationException("Invalid implicit variable discriminator: ", invalidImplicitDiscriminatorException);
        }
    }

    @Override
    void prepare(Target target, InjectionNodes.InjectionNode injectionNode) {
        this.getOrCreateLocalContext(target, injectionNode);
    }

    @Override
    void inject(Target target, InjectionNodes.InjectionNode injectionNode, StackExtension stackExtension) {
        LocalVariableDiscriminator.Context context;
        LocalVariableDiscriminator localVariableDiscriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.sugar);
        int n2 = localVariableDiscriminator.findLocal(context = (LocalVariableDiscriminator.Context)injectionNode.getDecoration(this.getLocalContextKey()));
        if (n2 < 0) {
            throw new SugarApplicationException("Failed to match a local, this should have been caught during validation.");
        }
        if (this.isMutable) {
            this.initAndLoadLocalRef(target, injectionNode, n2, stackExtension);
            return;
        }
        stackExtension.extra(this.targetLocalType.getSize());
        target.insns.insertBefore(injectionNode.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(21), n2));
    }

    @Override
    int postProcessingPriority() {
        return 1000;
    }

    private void initAndLoadLocalRef(Target target, InjectionNodes.InjectionNode injectionNode, int n2, StackExtension stackExtension) {
        String string = LocalRefClassGenerator.getForType(this.targetLocalType);
        n2 = this.getOrCreateRef(target, injectionNode, n2, string, stackExtension);
        stackExtension.extra(1);
        target.insns.insertBefore(injectionNode.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(25, n2));
    }

    private int getOrCreateRef(Target target, InjectionNodes.InjectionNode injectionNode, int n2, String string, StackExtension stackExtension) {
        HashMap<Integer, Integer> hashMap = (HashMap<Integer, Integer>)injectionNode.getDecoration("mixinextras_localRefMap");
        if (hashMap == null) {
            hashMap = new HashMap<Integer, Integer>();
            injectionNode.decorate("mixinextras_localRefMap", hashMap);
        }
        if (hashMap.containsKey(n2)) {
            return (Integer)hashMap.get(n2);
        }
        int n3 = target.allocateLocal();
        target.addLocalVariable(n3, "ref".concat(String.valueOf(n3)), "L" + string + ';');
        string = new InsnList();
        LocalRefUtils.generateNew((InsnList)string, this.targetLocalType);
        string.add((AbstractInsnNode)new VarInsnNode(58, n3));
        target.insertBefore(injectionNode, (InsnList)string);
        LocalSugarApplicator localSugarApplicator = this;
        SugarPostProcessingExtension.enqueuePostProcessing(localSugarApplicator, () -> {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, n3));
            insnList.add((AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(21), n2));
            LocalRefUtils.generateInitialization(insnList, this.targetLocalType);
            target.insertBefore(injectionNode, insnList);
            insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, n3));
            LocalRefUtils.generateDisposal(insnList, this.targetLocalType);
            insnList.add((AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(54), n2));
            target.insns.insert(injectionNode.getCurrentTarget(), insnList);
        });
        stackExtension.extra(this.targetLocalType.getSize() + 1);
        hashMap.put(n2, n3);
        return n3;
    }

    private LocalVariableDiscriminator.Context getOrCreateLocalContext(Target target, InjectionNodes.InjectionNode injectionNode) {
        String string = this.getLocalContextKey();
        if (injectionNode.hasDecoration(string)) {
            return (LocalVariableDiscriminator.Context)injectionNode.getDecoration(string);
        }
        target = CompatibilityHelper.makeLvtContext(this.info, this.targetLocalType, this.isArgsOnly, target, injectionNode.getCurrentTarget());
        injectionNode.decorate(string, (Object)target);
        return target;
    }

    private String getLocalContextKey() {
        return String.format("mixinextras_persistent_localSugarContext(%s,%s)", this.targetLocalType, this.isArgsOnly ? "argsOnly" : "fullFrame");
    }

    private void printLocals(Target target, AbstractInsnNode abstractInsnNode, LocalVariableDiscriminator.Context context, LocalVariableDiscriminator localVariableDiscriminator) {
        int n2 = target.isStatic ? 0 : 1;
        new PrettyPrinter().kvWidth(20).kv("Target Class", (Object)target.classNode.name.replace('/', '.')).kv("Target Method", (Object)target.method.name).kv("Capture Type", (Object)SignaturePrinter.getTypeName((Type)this.targetLocalType, (boolean)false)).kv("Instruction", "[%d] %s %s", new Object[]{target.insns.indexOf(abstractInsnNode), abstractInsnNode.getClass().getSimpleName(), Bytecode.getOpcodeName((int)abstractInsnNode.getOpcode())}).hr().kv("Match mode", (Object)(this.isImplicit(localVariableDiscriminator, n2) ? "IMPLICIT (match single)" : "EXPLICIT (match by criteria)")).kv("Match ordinal", localVariableDiscriminator.getOrdinal() < 0 ? "any" : Integer.valueOf(localVariableDiscriminator.getOrdinal())).kv("Match index", localVariableDiscriminator.getIndex() < n2 ? "any" : Integer.valueOf(localVariableDiscriminator.getIndex())).kv("Match name(s)", localVariableDiscriminator.hasNames() ? localVariableDiscriminator.getNames() : "any").kv("Args only", (Object)this.isArgsOnly).hr().add((PrettyPrinter.IPrettyPrintable)context).print(System.err);
    }

    private boolean isImplicit(LocalVariableDiscriminator localVariableDiscriminator, int n2) {
        return localVariableDiscriminator.getOrdinal() < 0 && localVariableDiscriminator.getIndex() < n2 && localVariableDiscriminator.getNames().isEmpty();
    }
}

