/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.ui.screen;

import com.mynamesraph.mystcraft.component.LocationComponent;
import com.mynamesraph.mystcraft.component.LocationDisplayComponent;
import com.mynamesraph.mystcraft.data.networking.packet.LinkingBookTravelPacket;
import com.mynamesraph.mystcraft.registry.MystcraftComponents;
import com.mynamesraph.mystcraft.ui.GUIHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0016J(\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/mynamesraph/mystcraft/ui/screen/LinkingBookScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "title", "Lnet/minecraft/network/chat/Component;", "hand", "Lnet/minecraft/world/InteractionHand;", "player", "Lnet/minecraft/world/entity/player/Player;", "<init>", "(Lnet/minecraft/network/chat/Component;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/entity/player/Player;)V", "TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "TEXTURE_UNUSABLE", "BACKGROUND_Y", "", "BACKGROUND_X", "TITLE_X", "TITLE_Y", "BUTTON_X", "BUTTON_Y", "init", "", "tick", "render", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "mouseY", "partialTick", "", "renderBackground", "guiGraphics", "onClose", "removed", "mystcraft_ageless"})
public class LinkingBookScreen
extends Screen {
    @NotNull
    private final InteractionHand hand;
    @NotNull
    private final Player player;
    @NotNull
    private final ResourceLocation TEXTURE;
    @NotNull
    private final ResourceLocation TEXTURE_UNUSABLE;
    private int BACKGROUND_Y;
    private int BACKGROUND_X;
    private int TITLE_X;
    private int TITLE_Y;
    private int BUTTON_X;
    private int BUTTON_Y;

    public LinkingBookScreen(@NotNull Component title, @NotNull InteractionHand hand, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(title);
        this.hand = hand;
        this.player = player;
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"mystcraft_ageless", (String)"textures/gui/book/linking_book.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        this.TEXTURE = resourceLocation;
        ResourceLocation resourceLocation2 = ResourceLocation.fromNamespaceAndPath((String)"mystcraft_ageless", (String)"textures/gui/book/linking_book_unusable.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"fromNamespaceAndPath(...)");
        this.TEXTURE_UNUSABLE = resourceLocation2;
    }

    protected void init() {
        super.init();
        Screen screen = Minecraft.getInstance().screen;
        Intrinsics.checkNotNull((Object)screen);
        this.BACKGROUND_X = screen.width / 2 - 128;
        Screen screen2 = Minecraft.getInstance().screen;
        Intrinsics.checkNotNull((Object)screen2);
        this.BACKGROUND_Y = screen2.height / 2 - 103;
        this.TITLE_X = this.BACKGROUND_X + 70;
        this.TITLE_Y = this.BACKGROUND_Y + 20;
        this.BUTTON_X = this.BACKGROUND_X + 146;
        this.BUTTON_Y = this.BACKGROUND_Y + 32;
        LocationComponent locationComponent = (LocationComponent)this.player.getItemInHand(this.hand).getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION().get());
        if (locationComponent != null) {
            Button button = Intrinsics.areEqual((Object)this.player.level().dimension(), locationComponent.getLevelKey()) ? (Button)this.addWidget((GuiEventListener)Button.builder((Component)((Component)Component.translatableWithFallback((String)"narration.mystcraft_ageless.linking_book_travel", (String)"Travel")), arg_0 -> LinkingBookScreen.init$lambda$0(this, arg_0)).pos(this.BUTTON_X, this.BUTTON_Y).size(80, 48).build()) : (Button)this.addWidget((GuiEventListener)Button.builder((Component)((Component)Component.translatableWithFallback((String)"narration.mystcraft_ageless.linking_book_travel", (String)"Travel")), arg_0 -> LinkingBookScreen.init$lambda$1(this, arg_0)).pos(this.BUTTON_X, this.BUTTON_Y).size(80, 48).build());
        }
    }

    public void tick() {
        super.tick();
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        LocationDisplayComponent titleComponent;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        LocationComponent locationComponent = (LocationComponent)this.player.getItemInHand(this.hand).getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION().get());
        if (locationComponent != null) {
            if (Intrinsics.areEqual((Object)this.player.level().dimension(), locationComponent.getLevelKey())) {
                guiGraphics.blit(this.TEXTURE_UNUSABLE, this.BACKGROUND_X, this.BACKGROUND_Y, 0, 0, 256, 181);
            } else {
                guiGraphics.blit(this.TEXTURE, this.BACKGROUND_X, this.BACKGROUND_Y, 0, 0, 256, 181);
            }
        }
        if ((titleComponent = (LocationDisplayComponent)this.player.getItemInHand(this.hand).getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY().get())) != null) {
            MutableComponent unformattedTitle = titleComponent.getName().copy();
            unformattedTitle = unformattedTitle.withStyle(Style.EMPTY.withColor(0x303030).withUnderlined(Boolean.valueOf(true)).withBold(Boolean.valueOf(true)));
            Font font = this.font;
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
            MutableComponent mutableComponent = unformattedTitle;
            Intrinsics.checkNotNull((Object)mutableComponent);
            GUIHelperKt.drawCenteredStringNoDropShadow(guiGraphics, font, (Component)mutableComponent, this.TITLE_X, this.TITLE_Y, 0);
        }
    }

    public void onClose() {
        super.onClose();
    }

    public void removed() {
        super.removed();
    }

    private static final void init$lambda$0(LinkingBookScreen this$0, Button it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.player.displayClientMessage((Component)Component.translatable((String)"message.mystcraft_ageless.no_same_dimension_travel"), false);
        this$0.onClose();
    }

    private static final void init$lambda$1(LinkingBookScreen this$0, Button it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        PacketDistributor.sendToServer((CustomPacketPayload)new LinkingBookTravelPacket(this$0.hand), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this$0.onClose();
    }
}

