/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.mixin;

import com.mojang.logging.LogUtils;
import com.mynamesraph.mystcraft.component.LocationDisplayComponent;
import com.mynamesraph.mystcraft.item.LinkingBookItem;
import com.mynamesraph.mystcraft.registry.MystcraftComponents;
import com.mynamesraph.mystcraft.registry.MystcraftItems;
import com.mynamesraph.mystcraft.ui.menu.LinkingBookMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LecternBlock.class})
public class LecternBlockMixin
extends Block {
    @Shadow
    @Final
    public static BooleanProperty HAS_BOOK;
    @Unique
    private static final BooleanProperty IS_MYSTCRAFT_BOOK;

    public LecternBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    protected void init(BlockBehaviour.Properties properties, CallbackInfo ci) {
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)IS_MYSTCRAFT_BOOK, (Comparable)Boolean.valueOf(false)));
    }

    @Inject(at={@At(value="HEAD")}, method={"createBlockStateDefinition"})
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        builder.add(new Property[]{IS_MYSTCRAFT_BOOK});
    }

    @Inject(at={@At(value="RETURN")}, method={"placeBook"})
    private static void placeBook(LivingEntity entity, Level level, BlockPos pos, BlockState state, ItemStack stack, CallbackInfo ci) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LecternBlockEntity) {
            LecternBlockEntity blockEntity2 = (LecternBlockEntity)blockEntity;
            boolean isMystcraftBook = blockEntity2.getBook().is(MystcraftItems.INSTANCE.getLINKING_BOOK());
            level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)IS_MYSTCRAFT_BOOK, (Comparable)Boolean.valueOf(isMystcraftBook)));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"useWithoutItem"}, cancellable=true)
    protected void useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        if (((Boolean)state.getValue((Property)HAS_BOOK)).booleanValue() && ((Boolean)state.getValue((Property)IS_MYSTCRAFT_BOOK)).booleanValue()) {
            if (!level.isClientSide) {
                this.mystcraft$openScreen(level, pos, player);
            }
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
    }

    @Unique
    protected void mystcraft$openScreen(Level level, BlockPos pos, Player serverPlayer) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof LecternBlockEntity) {
            LecternBlockEntity lecternBE = (LecternBlockEntity)be;
            if (((Boolean)be.getBlockState().getValue((Property)IS_MYSTCRAFT_BOOK)).booleanValue()) {
                Item linkingBook = lecternBE.getBook().getItem();
                if (linkingBook instanceof LinkingBookItem) {
                    LocationDisplayComponent locationDisplay = (LocationDisplayComponent)lecternBE.getBook().getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY().get());
                    if (locationDisplay instanceof LocationDisplayComponent) {
                        serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, player) -> new LinkingBookMenu(containerId, playerInventory, pos), locationDisplay.getName()), pos);
                    }
                    serverPlayer.awardStat(Stats.INTERACT_WITH_LECTERN);
                } else {
                    LogUtils.getLogger().warn("Lectern has is_mystcraft_book set to true without a mystcraft book inside it!");
                }
            }
        }
    }

    static {
        IS_MYSTCRAFT_BOOK = BooleanProperty.create((String)"is_mystcraft_book");
    }
}

