/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.item;

import com.mynamesraph.mystcraft.component.BiomeSymbolsComponent;
import com.mynamesraph.mystcraft.component.IsCreativeSpawnedComponent;
import com.mynamesraph.mystcraft.registry.MystcraftComponents;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/mynamesraph/mystcraft/item/NotebookItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "inventoryTick", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "slotId", "", "isSelected", "", "mystcraft_ageless"})
public final class NotebookItem
extends Item {
    public NotebookItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        BiomeSymbolsComponent biomes;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        IsCreativeSpawnedComponent creativeSpawned = (IsCreativeSpawnedComponent)stack.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getIS_CREATIVE_SPAWNED().get());
        if (creativeSpawned != null) {
            MutableComponent mutableComponent = Component.translatable((String)"mystcraft_ageless.tooltip_messages.creative_spawned");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            tooltipComponents.add((Component)mutableComponent);
        }
        if ((biomes = (BiomeSymbolsComponent)stack.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getBIOME_SYMBOLS().get())) != null) {
            Object[] objectArray = new Object[]{((Collection)biomes.biomes()).size()};
            MutableComponent mutableComponent = Component.translatable((String)"mystcraft_ageless.tooltip_messages.biomes", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            tooltipComponents.add((Component)mutableComponent);
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!level.isClientSide) {
            MinecraftServer minecraftServer = entity.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            MinecraftServer server = minecraftServer;
            if (stack.getComponents().has((DataComponentType)MystcraftComponents.INSTANCE.getIS_CREATIVE_SPAWNED().get())) {
                Object object = stack.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getIS_CREATIVE_SPAWNED().get());
                Intrinsics.checkNotNull((Object)object);
                if (((IsCreativeSpawnedComponent)object).generated()) {
                    return;
                }
                PatchedDataComponentMap patchedComponents = new PatchedDataComponentMap(stack.getComponents());
                patchedComponents.set((DataComponentType)MystcraftComponents.INSTANCE.getIS_CREATIVE_SPAWNED().get(), (Object)new IsCreativeSpawnedComponent(true));
                DataComponentType dataComponentType = (DataComponentType)MystcraftComponents.INSTANCE.getBIOME_SYMBOLS().get();
                Set set = server.registryAccess().registryOrThrow(Registries.BIOME).keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
                patchedComponents.set(dataComponentType, (Object)new BiomeSymbolsComponent(CollectionsKt.toList((Iterable)set)));
                stack.applyComponentsAndValidate(patchedComponents.asPatch());
            }
        }
    }
}

