/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.item;

import com.mynamesraph.mystcraft.component.LocationComponent;
import com.mynamesraph.mystcraft.component.LocationDisplayComponent;
import com.mynamesraph.mystcraft.component.RotationComponent;
import com.mynamesraph.mystcraft.registry.MystcraftComponents;
import com.mynamesraph.mystcraft.ui.screen.LinkingBookScreen;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3fc;
import thedarkcolour.kotlinforforge.neoforge.forge.vectorutil.v3d.Vec3iUtilKt;
import thedarkcolour.kotlinforforge.neoforge.forge.vectorutil.v3d.Vector3fcUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J \u0010\u001d\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J(\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016\u00a8\u0006'"}, d2={"Lcom/mynamesraph/mystcraft/item/LinkingBookItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "getHighlightTip", "Lnet/minecraft/network/chat/Component;", "item", "Lnet/minecraft/world/item/ItemStack;", "displayName", "appendHoverText", "", "stack", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "openScreen", "teleportToLocationFromHand", "teleportToLocationFromLectern", "entity", "Lnet/minecraft/world/entity/Entity;", "location", "Lcom/mynamesraph/mystcraft/component/LocationComponent;", "rotation", "Lcom/mynamesraph/mystcraft/component/RotationComponent;", "getDestination", "Lnet/minecraft/world/level/portal/DimensionTransition;", "mystcraft_ageless"})
public class LinkingBookItem
extends Item {
    public LinkingBookItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public Component getHighlightTip(@NotNull ItemStack item, @NotNull Component displayName) {
        LocationDisplayComponent display;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        if (item.has((Supplier)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY()) && (display = (LocationDisplayComponent)item.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY().get())) != null) {
            MutableComponent mutableComponent = display.getName().plainCopy();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"plainCopy(...)");
            return (Component)mutableComponent;
        }
        Component component = super.getHighlightTip(item, displayName);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getHighlightTip(...)");
        return component;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        LocationDisplayComponent display = (LocationDisplayComponent)stack.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY().get());
        if (display != null) {
            tooltipComponents.add(display.getName());
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        this.openScreen(level, player, usedHand);
        InteractionResultHolder interactionResultHolder = super.use(level, player, usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    protected void openScreen(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (level.isClientSide) {
            Minecraft minecraft = Minecraft.getInstance();
            MutableComponent mutableComponent = Component.literal((String)"linking_book_screen");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            minecraft.setScreen((Screen)new LinkingBookScreen((Component)mutableComponent, usedHand, player));
        }
    }

    public void teleportToLocationFromHand(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (!level.isClientSide()) {
            LocationComponent location = (LocationComponent)player.getItemInHand(usedHand).get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION().get());
            RotationComponent rotation = (RotationComponent)player.getItemInHand(usedHand).get((DataComponentType)MystcraftComponents.INSTANCE.getROTATION().get());
            if (location != null && rotation != null) {
                this.teleportToLocationFromLectern(level, (Entity)player, location, rotation);
            }
        }
    }

    public void teleportToLocationFromLectern(@NotNull Level level, @NotNull Entity entity, @NotNull LocationComponent location, @NotNull RotationComponent rotation) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        if (!level.isClientSide()) {
            MinecraftServer minecraftServer = level.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            ServerLevel locationLevel = minecraftServer.getLevel(location.getLevelKey());
            if (locationLevel == null) {
                MinecraftServer minecraftServer2 = level.getServer();
                Intrinsics.checkNotNull((Object)minecraftServer2);
                locationLevel = minecraftServer2.getLevel(ServerLevel.OVERWORLD);
                System.err.println("Attempted teleporting to an Unknown dimension " + location.getLevelKey() + " !");
                ServerLevel serverLevel = locationLevel;
                Intrinsics.checkNotNull((Object)serverLevel);
                if (!Intrinsics.areEqual((Object)serverLevel.getLevel(), (Object)level)) {
                    System.err.println("Safely teleporting player to the overworld!");
                    BlockPos blockPos = locationLevel.getSharedSpawnPos();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getSharedSpawnPos(...)");
                    entity.changeDimension(new DimensionTransition(locationLevel, Vec3iUtilKt.toVec3((Vec3i)((Vec3i)blockPos)), entity.getDeltaMovement(), 0.0f, 0.0f, DimensionTransition.DO_NOTHING));
                }
                return;
            }
            entity.changeDimension(new DimensionTransition(locationLevel, Vector3fcUtilKt.toVec3((Vector3fc)((Vector3fc)location.getPosition())), entity.getDeltaMovement(), rotation.rotY(), rotation.rotX(), DimensionTransition.DO_NOTHING));
        }
    }

    @NotNull
    public DimensionTransition getDestination(@NotNull Level level, @NotNull Entity entity, @NotNull LocationComponent location, @NotNull RotationComponent rotation) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        MinecraftServer minecraftServer = level.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        ServerLevel locationLevel = minecraftServer.getLevel(location.getLevelKey());
        if (locationLevel == null) {
            MinecraftServer minecraftServer2 = level.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer2);
            locationLevel = minecraftServer2.getLevel(ServerLevel.OVERWORLD);
            System.err.println("Attempted teleporting to an Unknown dimension " + location.getLevelKey() + " !");
            ServerLevel serverLevel = locationLevel;
            Intrinsics.checkNotNull((Object)serverLevel);
            if (!Intrinsics.areEqual((Object)serverLevel.getLevel(), (Object)level)) {
                System.err.println("Safely teleporting player to the overworld!");
                BlockPos blockPos = locationLevel.getSharedSpawnPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getSharedSpawnPos(...)");
                return new DimensionTransition(locationLevel, Vec3iUtilKt.toVec3((Vec3i)((Vec3i)blockPos)), entity.getDeltaMovement(), 0.0f, 0.0f, DimensionTransition.DO_NOTHING);
            }
        }
        return new DimensionTransition(locationLevel, Vector3fcUtilKt.toVec3((Vector3fc)((Vector3fc)location.getPosition())), entity.getDeltaMovement(), rotation.rotY(), rotation.rotX(), DimensionTransition.DO_NOTHING);
    }
}

