/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.data.networking.handlers;

import com.mojang.logging.LogUtils;
import com.mynamesraph.mystcraft.block.writing.WritingDeskBlockEntity;
import com.mynamesraph.mystcraft.component.BiomeSymbolsComponent;
import com.mynamesraph.mystcraft.component.LocationComponent;
import com.mynamesraph.mystcraft.component.LocationDisplayComponent;
import com.mynamesraph.mystcraft.component.RotationComponent;
import com.mynamesraph.mystcraft.data.networking.packet.LinkingBookLecternTravelPacket;
import com.mynamesraph.mystcraft.data.networking.packet.LinkingBookTravelPacket;
import com.mynamesraph.mystcraft.data.networking.packet.WritingDeskRenamePacket;
import com.mynamesraph.mystcraft.data.networking.packet.WritingDeskSymbolPacket;
import com.mynamesraph.mystcraft.item.LinkingBookItem;
import com.mynamesraph.mystcraft.registry.MystcraftComponents;
import com.mynamesraph.mystcraft.registry.MystcraftItems;
import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/mynamesraph/mystcraft/data/networking/handlers/MystCraftServerPayloadHandler;", "", "<init>", "()V", "Companion", "mystcraft_ageless"})
public final class MystCraftServerPayloadHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"Lcom/mynamesraph/mystcraft/data/networking/handlers/MystCraftServerPayloadHandler$Companion;", "", "<init>", "()V", "handleWritingDeskAddingSymbol", "", "data", "Lcom/mynamesraph/mystcraft/data/networking/packet/WritingDeskSymbolPacket;", "context", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "handleWritingDeskAddingBiomeSymbol", "handleWritingDeskRenamedBook", "Lcom/mynamesraph/mystcraft/data/networking/packet/WritingDeskRenamePacket;", "handleLinkingBookButtonPressed", "Lcom/mynamesraph/mystcraft/data/networking/packet/LinkingBookTravelPacket;", "handleLecternLinkingBookButtonPressed", "Lcom/mynamesraph/mystcraft/data/networking/packet/LinkingBookLecternTravelPacket;", "mystcraft_ageless"})
    @SourceDebugExtension(value={"SMAP\nMystCraftServerPayloadHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MystCraftServerPayloadHandler.kt\ncom/mynamesraph/mystcraft/data/networking/handlers/MystCraftServerPayloadHandler$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,151:1\n37#2,2:152\n*S KotlinDebug\n*F\n+ 1 MystCraftServerPayloadHandler.kt\ncom/mynamesraph/mystcraft/data/networking/handlers/MystCraftServerPayloadHandler$Companion\n*L\n54#1:152,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void handleWritingDeskAddingSymbol(@NotNull WritingDeskSymbolPacket data, @NotNull IPayloadContext context) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (Intrinsics.areEqual((Object)data.getType(), (Object)"BIOME")) {
                this.handleWritingDeskAddingBiomeSymbol(data, context);
            } else {
                LogUtils.getLogger().error("MystCraftServerPayloadHandler#handleWritingDeskAddingSymbol: Unknown symbol type: " + data.getType());
            }
        }

        private final void handleWritingDeskAddingBiomeSymbol(WritingDeskSymbolPacket data, IPayloadContext context) {
            ItemStack item;
            Player player = context.player();
            Level level = player.level();
            BlockEntity writingDesk = level.getBlockEntity(data.getWritingDeskPos());
            if (writingDesk instanceof WritingDeskBlockEntity && (item = ((WritingDeskBlockEntity)writingDesk).getContainer().getStackInSlot(0)).is((Holder)MystcraftItems.INSTANCE.getDESCRIPTIVE_BOOK())) {
                PatchedDataComponentMap patched = new PatchedDataComponentMap(item.getComponents());
                BiomeSymbolsComponent biomeSymbols = (BiomeSymbolsComponent)item.getComponents().get((DataComponentType)MystcraftComponents.INSTANCE.getBIOME_SYMBOLS().get());
                if (biomeSymbols != null) {
                    DataComponentType dataComponentType = (DataComponentType)MystcraftComponents.INSTANCE.getBIOME_SYMBOLS().get();
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    Collection $this$toTypedArray$iv = biomeSymbols.biomes();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new ResourceLocation[0]));
                    spreadBuilder.add((Object)data.getSymbol());
                    v1 = (BiomeSymbolsComponent)patched.set(dataComponentType, (Object)new BiomeSymbolsComponent(CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new ResourceLocation[spreadBuilder.size()]))));
                } else {
                    v1 = (BiomeSymbolsComponent)patched.set((DataComponentType)MystcraftComponents.INSTANCE.getBIOME_SYMBOLS().get(), (Object)new BiomeSymbolsComponent(CollectionsKt.listOf((Object)data.getSymbol())));
                }
                item.applyComponentsAndValidate(patched.asPatch());
            }
        }

        public final void handleWritingDeskRenamedBook(@NotNull WritingDeskRenamePacket data, @NotNull IPayloadContext context) {
            ItemStack item;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Player player = context.player();
            Level level = player.level();
            BlockEntity writingDesk = level.getBlockEntity(data.getWritingDeskPos());
            if (writingDesk instanceof WritingDeskBlockEntity && (item = ((WritingDeskBlockEntity)writingDesk).getContainer().getStackInSlot(0)).has((Supplier)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY())) {
                PatchedDataComponentMap patchedComponents = new PatchedDataComponentMap(item.getComponents());
                if (patchedComponents.get((DataComponentType)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY().get()) != null) {
                    DataComponentType dataComponentType = (DataComponentType)MystcraftComponents.INSTANCE.getLOCATION_DISPLAY().get();
                    MutableComponent mutableComponent = Component.literal((String)data.getName()).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(0xAAAAAA));
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                    patchedComponents.set(dataComponentType, (Object)new LocationDisplayComponent((Component)mutableComponent));
                }
                item.applyComponentsAndValidate(patchedComponents.asPatch());
            }
        }

        public final void handleLinkingBookButtonPressed(@NotNull LinkingBookTravelPacket data, @NotNull IPayloadContext context) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Player player = context.player();
            Level level = player.level();
            Item item = player.getItemInHand(data.getInteractionHand()).getItem();
            System.out.println((Object)("Received Packet From " + player.getUUID() + ": " + data));
            if (item instanceof LinkingBookItem) {
                LinkingBookItem linkingBookItem = (LinkingBookItem)item;
                Intrinsics.checkNotNull((Object)level);
                Intrinsics.checkNotNull((Object)player);
                linkingBookItem.teleportToLocationFromHand(level, player, data.getInteractionHand());
            }
        }

        public final void handleLecternLinkingBookButtonPressed(@NotNull LinkingBookLecternTravelPacket data, @NotNull IPayloadContext context) {
            Item book;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Player player = context.player();
            Level level = player.level();
            BlockEntity lectern = level.getBlockEntity(data.getPos());
            if (lectern instanceof LecternBlockEntity && (book = ((LecternBlockEntity)lectern).getBook().getItem()) instanceof LinkingBookItem) {
                DataComponentMap dataComponentMap = ((LecternBlockEntity)lectern).getBook().getComponents();
                Object object = BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"mystcraft_ageless", (String)"location"));
                Intrinsics.checkNotNull((Object)object);
                Object location = dataComponentMap.get((DataComponentType)object);
                DataComponentMap dataComponentMap2 = ((LecternBlockEntity)lectern).getBook().getComponents();
                Object object2 = BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"mystcraft_ageless", (String)"rotation"));
                Intrinsics.checkNotNull((Object)object2);
                Object rotation = dataComponentMap2.get((DataComponentType)object2);
                if (location instanceof LocationComponent && rotation instanceof RotationComponent) {
                    System.out.println((Object)("location:" + location + ", rotation:" + rotation));
                    LinkingBookItem linkingBookItem = (LinkingBookItem)book;
                    Intrinsics.checkNotNull((Object)level);
                    Intrinsics.checkNotNull((Object)player);
                    linkingBookItem.teleportToLocationFromLectern(level, (Entity)player, (LocationComponent)location, (RotationComponent)rotation);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

