/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.data.datagen.item;

import com.mynamesraph.mystcraft.block.crystal.CrystalColor;
import com.mynamesraph.mystcraft.registry.MystcraftBlocks;
import com.mynamesraph.mystcraft.registry.MystcraftItems;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014Jd\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u001a\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/mynamesraph/mystcraft/data/datagen/item/MystcraftItemModelProvider;", "Lnet/neoforged/neoforge/client/model/generators/ItemModelProvider;", "output", "Lnet/minecraft/data/PackOutput;", "existingFileHelper", "Lnet/neoforged/neoforge/common/data/ExistingFileHelper;", "<init>", "(Lnet/minecraft/data/PackOutput;Lnet/neoforged/neoforge/common/data/ExistingFileHelper;)V", "registerModels", "", "registerCrystalModels", "item", "Lnet/neoforged/neoforge/registries/DeferredItem;", "Lnet/minecraft/world/item/Item;", "small", "Lnet/neoforged/neoforge/registries/DeferredBlock;", "Lnet/minecraft/world/level/block/Block;", "medium", "large", "cluster", "color", "Lcom/mynamesraph/mystcraft/block/crystal/CrystalColor;", "receptacle", "budBlockItem", "Lnet/neoforged/neoforge/client/model/generators/ItemModelBuilder;", "block", "flatBlockItem", "mystcraft_ageless"})
public final class MystcraftItemModelProvider
extends ItemModelProvider {
    public MystcraftItemModelProvider(@NotNull PackOutput output, @NotNull ExistingFileHelper existingFileHelper) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)existingFileHelper, (String)"existingFileHelper");
        super(output, "mystcraft_ageless", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)MystcraftItems.INSTANCE.getLINKING_BOOK().get());
        this.basicItem((Item)MystcraftItems.INSTANCE.getDESCRIPTIVE_BOOK().get());
        this.basicItem((Item)MystcraftBlocks.INSTANCE.getWRITING_DESK_ITEM().get());
        this.basicItem((Item)MystcraftItems.INSTANCE.getNOTEBOOK().get());
        this.simpleBlockItem((Block)MystcraftBlocks.INSTANCE.getLINK_PORTAL().get());
        this.registerCrystalModels(MystcraftItems.INSTANCE.getBLUE_CRYSTAL(), MystcraftBlocks.INSTANCE.getSMALL_BLUE_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getMEDIUM_BLUE_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getLARGE_BLUE_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getBLUE_CRYSTAL_CLUSTER(), CrystalColor.BLUE, MystcraftBlocks.INSTANCE.getBLUE_BOOK_RECEPTACLE());
        this.registerCrystalModels(MystcraftItems.INSTANCE.getYELLOW_CRYSTAL(), MystcraftBlocks.INSTANCE.getSMALL_YELLOW_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getMEDIUM_YELLOW_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getLARGE_YELLOW_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getYELLOW_CRYSTAL_CLUSTER(), CrystalColor.YELLOW, MystcraftBlocks.INSTANCE.getYELLOW_BOOK_RECEPTACLE());
        this.registerCrystalModels(MystcraftItems.INSTANCE.getGREEN_CRYSTAL(), MystcraftBlocks.INSTANCE.getSMALL_GREEN_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getMEDIUM_GREEN_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getLARGE_GREEN_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getGREEN_CRYSTAL_CLUSTER(), CrystalColor.GREEN, MystcraftBlocks.INSTANCE.getGREEN_BOOK_RECEPTACLE());
        this.registerCrystalModels(MystcraftItems.INSTANCE.getPINK_CRYSTAL(), MystcraftBlocks.INSTANCE.getSMALL_PINK_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getMEDIUM_PINK_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getLARGE_PINK_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getPINK_CRYSTAL_CLUSTER(), CrystalColor.PINK, MystcraftBlocks.INSTANCE.getPINK_BOOK_RECEPTACLE());
        this.registerCrystalModels(MystcraftItems.INSTANCE.getRED_CRYSTAL(), MystcraftBlocks.INSTANCE.getSMALL_RED_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getMEDIUM_RED_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getLARGE_RED_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getRED_CRYSTAL_CLUSTER(), CrystalColor.RED, MystcraftBlocks.INSTANCE.getRED_BOOK_RECEPTACLE());
    }

    private final void registerCrystalModels(DeferredItem<Item> item, DeferredBlock<Block> small, DeferredBlock<Block> medium, DeferredBlock<Block> large, DeferredBlock<Block> cluster, CrystalColor color, DeferredBlock<Block> receptacle) {
        this.basicItem((Item)item.get());
        this.budBlockItem(small, color);
        this.budBlockItem(medium, color);
        this.budBlockItem(large, color);
        this.flatBlockItem(cluster, color);
        this.simpleBlockItem((Block)receptacle.get());
    }

    private final ItemModelBuilder budBlockItem(DeferredBlock<?> block, CrystalColor color) {
        String string = block.getRegisteredName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRegisteredName(...)");
        String blockName = StringsKt.replace$default((String)string, (String)"mystcraft_ageless:", (String)"", (boolean)false, (int)4, null);
        String string2 = color.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"mystcraft_ageless", (String)("block/crystal_cluster/" + string2 + "/" + blockName));
        ModelBuilder modelBuilder = ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(blockName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/amethyst_bud"))).texture("layer0", texture);
        Intrinsics.checkNotNullExpressionValue((Object)modelBuilder, (String)"texture(...)");
        return (ItemModelBuilder)modelBuilder;
    }

    private final ItemModelBuilder flatBlockItem(DeferredBlock<?> block, CrystalColor color) {
        String string = block.getRegisteredName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRegisteredName(...)");
        String blockName = StringsKt.replace$default((String)string, (String)"mystcraft_ageless:", (String)"", (boolean)false, (int)4, null);
        String string2 = color.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"mystcraft_ageless", (String)("block/crystal_cluster/" + string2 + "/" + blockName));
        ModelBuilder modelBuilder = ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(blockName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
        Intrinsics.checkNotNullExpressionValue((Object)modelBuilder, (String)"texture(...)");
        return (ItemModelBuilder)modelBuilder;
    }
}

