/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft.data.datagen.block;

import com.mynamesraph.mystcraft.block.crystal.CrystalColor;
import com.mynamesraph.mystcraft.registry.MystcraftBlocks;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014Jr\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0014\u0010\u0016\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u001c\u0010\u0017\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/mynamesraph/mystcraft/data/datagen/block/MystcraftBlockStateProvider;", "Lnet/neoforged/neoforge/client/model/generators/BlockStateProvider;", "output", "Lnet/minecraft/data/PackOutput;", "exFileHelper", "Lnet/neoforged/neoforge/common/data/ExistingFileHelper;", "<init>", "(Lnet/minecraft/data/PackOutput;Lnet/neoforged/neoforge/common/data/ExistingFileHelper;)V", "registerStatesAndModels", "", "registerCrystalStatesAndModels", "block", "Lnet/neoforged/neoforge/registries/DeferredBlock;", "Lnet/minecraft/world/level/block/Block;", "budding", "small", "medium", "large", "cluster", "color", "Lcom/mynamesraph/mystcraft/block/crystal/CrystalColor;", "receptacle", "cubeWithItem", "clusterBlock", "mystcraft_ageless"})
public final class MystcraftBlockStateProvider
extends BlockStateProvider {
    @NotNull
    private final ExistingFileHelper exFileHelper;

    public MystcraftBlockStateProvider(@NotNull PackOutput output, @NotNull ExistingFileHelper exFileHelper) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)exFileHelper, (String)"exFileHelper");
        super(output, "mystcraft_ageless", exFileHelper);
        this.exFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        this.registerCrystalStatesAndModels(MystcraftBlocks.INSTANCE.getBLUE_CRYSTAL_BLOCK(), MystcraftBlocks.INSTANCE.getBUDDING_BLUE_CRYSTAL(), MystcraftBlocks.INSTANCE.getSMALL_BLUE_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getMEDIUM_BLUE_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getLARGE_BLUE_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getBLUE_CRYSTAL_CLUSTER(), CrystalColor.BLUE, MystcraftBlocks.INSTANCE.getBLUE_BOOK_RECEPTACLE());
        this.registerCrystalStatesAndModels(MystcraftBlocks.INSTANCE.getYELLOW_CRYSTAL_BLOCK(), MystcraftBlocks.INSTANCE.getBUDDING_YELLOW_CRYSTAL(), MystcraftBlocks.INSTANCE.getSMALL_YELLOW_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getMEDIUM_YELLOW_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getLARGE_YELLOW_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getYELLOW_CRYSTAL_CLUSTER(), CrystalColor.YELLOW, MystcraftBlocks.INSTANCE.getYELLOW_BOOK_RECEPTACLE());
        this.registerCrystalStatesAndModels(MystcraftBlocks.INSTANCE.getGREEN_CRYSTAL_BLOCK(), MystcraftBlocks.INSTANCE.getBUDDING_GREEN_CRYSTAL(), MystcraftBlocks.INSTANCE.getSMALL_GREEN_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getMEDIUM_GREEN_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getLARGE_GREEN_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getGREEN_CRYSTAL_CLUSTER(), CrystalColor.GREEN, MystcraftBlocks.INSTANCE.getGREEN_BOOK_RECEPTACLE());
        this.registerCrystalStatesAndModels(MystcraftBlocks.INSTANCE.getPINK_CRYSTAL_BLOCK(), MystcraftBlocks.INSTANCE.getBUDDING_PINK_CRYSTAL(), MystcraftBlocks.INSTANCE.getSMALL_PINK_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getMEDIUM_PINK_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getLARGE_PINK_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getPINK_CRYSTAL_CLUSTER(), CrystalColor.PINK, MystcraftBlocks.INSTANCE.getPINK_BOOK_RECEPTACLE());
        this.registerCrystalStatesAndModels(MystcraftBlocks.INSTANCE.getRED_CRYSTAL_BLOCK(), MystcraftBlocks.INSTANCE.getBUDDING_RED_CRYSTAL(), MystcraftBlocks.INSTANCE.getSMALL_RED_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getMEDIUM_RED_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getLARGE_RED_CRYSTAL_BUD(), MystcraftBlocks.INSTANCE.getRED_CRYSTAL_CLUSTER(), CrystalColor.RED, MystcraftBlocks.INSTANCE.getRED_BOOK_RECEPTACLE());
    }

    private final void registerCrystalStatesAndModels(DeferredBlock<Block> block, DeferredBlock<Block> budding, DeferredBlock<Block> small, DeferredBlock<Block> medium, DeferredBlock<Block> large, DeferredBlock<Block> cluster, CrystalColor color, DeferredBlock<Block> receptacle) {
        this.cubeWithItem(block);
        this.cubeWithItem(budding);
        this.clusterBlock(small, color);
        this.clusterBlock(medium, color);
        this.clusterBlock(large, color);
        this.clusterBlock(cluster, color);
        Block block2 = (Block)receptacle.get();
        String string = color.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.directionalBlock(block2, (ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"mystcraft_ageless", (String)("block/" + string + "_book_receptacle"))));
    }

    private final void cubeWithItem(DeferredBlock<?> block) {
        this.simpleBlockWithItem((Block)block.get(), this.cubeAll((Block)block.get()));
    }

    private final void clusterBlock(DeferredBlock<?> block, CrystalColor color) {
        String string = block.getRegisteredName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRegisteredName(...)");
        String blockName = StringsKt.replace$default((String)string, (String)"mystcraft_ageless:", (String)"", (boolean)false, (int)4, null);
        String string2 = color.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"mystcraft_ageless", (String)("block/crystal_cluster/" + string2 + "/" + blockName));
        this.directionalBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().cross(blockName, texture)).renderType("minecraft:cutout_mipped"));
    }
}

