/*
 * Decompiled with CFR 0.152.
 */
package com.mynamesraph.mystcraft;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="mystcraft_ageless", bus=EventBusSubscriber.Bus.MOD)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u0001H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R \u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u00063"}, d2={"Lcom/mynamesraph/mystcraft/Config;", "", "<init>", "()V", "BUILDER", "Lnet/neoforged/neoforge/common/ModConfigSpec$Builder;", "LOG_DIRT_BLOCK", "Lnet/neoforged/neoforge/common/ModConfigSpec$BooleanValue;", "MAGIC_NUMBER", "Lnet/neoforged/neoforge/common/ModConfigSpec$IntValue;", "MAGIC_NUMBER_INTRODUCTION", "Lnet/neoforged/neoforge/common/ModConfigSpec$ConfigValue;", "", "getMAGIC_NUMBER_INTRODUCTION", "()Lnet/neoforged/neoforge/common/ModConfigSpec$ConfigValue;", "ITEM_STRINGS", "", "SPEC", "Lnet/neoforged/neoforge/common/ModConfigSpec;", "getSPEC", "()Lnet/neoforged/neoforge/common/ModConfigSpec;", "logDirtBlock", "", "getLogDirtBlock", "()Z", "setLogDirtBlock", "(Z)V", "magicNumber", "", "getMagicNumber", "()I", "setMagicNumber", "(I)V", "magicNumberIntroduction", "getMagicNumberIntroduction", "()Ljava/lang/String;", "setMagicNumberIntroduction", "(Ljava/lang/String;)V", "items", "", "Lnet/minecraft/world/item/Item;", "getItems", "()Ljava/util/Set;", "setItems", "(Ljava/util/Set;)V", "validateItemName", "obj", "onLoad", "", "event", "Lnet/neoforged/fml/event/config/ModConfigEvent;", "mystcraft_ageless"})
public final class Config {
    @NotNull
    public static final Config INSTANCE = new Config();
    @NotNull
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    @NotNull
    private static final ModConfigSpec.BooleanValue LOG_DIRT_BLOCK;
    @NotNull
    private static final ModConfigSpec.IntValue MAGIC_NUMBER;
    @NotNull
    private static final ModConfigSpec.ConfigValue<String> MAGIC_NUMBER_INTRODUCTION;
    @NotNull
    private static final ModConfigSpec.ConfigValue<List<String>> ITEM_STRINGS;
    @NotNull
    private static final ModConfigSpec SPEC;
    private static boolean logDirtBlock;
    private static int magicNumber;
    public static String magicNumberIntroduction;
    public static Set<? extends Item> items;

    private Config() {
    }

    @NotNull
    public final ModConfigSpec.ConfigValue<String> getMAGIC_NUMBER_INTRODUCTION() {
        return MAGIC_NUMBER_INTRODUCTION;
    }

    @NotNull
    public final ModConfigSpec getSPEC() {
        return SPEC;
    }

    public final boolean getLogDirtBlock() {
        return logDirtBlock;
    }

    public final void setLogDirtBlock(boolean bl) {
        logDirtBlock = bl;
    }

    public final int getMagicNumber() {
        return magicNumber;
    }

    public final void setMagicNumber(int n) {
        magicNumber = n;
    }

    @NotNull
    public final String getMagicNumberIntroduction() {
        String string = magicNumberIntroduction;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"magicNumberIntroduction");
        return null;
    }

    public final void setMagicNumberIntroduction(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        magicNumberIntroduction = string;
    }

    @NotNull
    public final Set<Item> getItems() {
        Set<Item> set = items;
        if (set != null) {
            return set;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"items");
        return null;
    }

    public final void setItems(@NotNull Set<? extends Item> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        items = set;
    }

    private final boolean validateItemName(Object obj) {
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)((String)obj)));
    }

    @SubscribeEvent
    public final void onLoad(@NotNull ModConfigEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logDirtBlock = (Boolean)LOG_DIRT_BLOCK.get();
        magicNumber = ((Number)MAGIC_NUMBER.get()).intValue();
        this.setMagicNumberIntroduction((String)MAGIC_NUMBER_INTRODUCTION.get());
        this.setItems(((List)ITEM_STRINGS.get()).stream().map(arg_0 -> Config.onLoad$lambda$1(Config::onLoad$lambda$0, arg_0)).collect(Collectors.toSet()));
    }

    private static final Item onLoad$lambda$0(String itemName) {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName));
    }

    private static final Item onLoad$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Item)$tmp0.invoke(p0);
    }

    static {
        ModConfigSpec.BooleanValue booleanValue = BUILDER.comment("Whether to log the dirt block on common setup").define("logDirtBlock", true);
        Intrinsics.checkNotNullExpressionValue((Object)booleanValue, (String)"define(...)");
        LOG_DIRT_BLOCK = booleanValue;
        ModConfigSpec.IntValue intValue = BUILDER.comment("A magic number").defineInRange("magicNumber", 42, 0, Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)intValue, (String)"defineInRange(...)");
        MAGIC_NUMBER = intValue;
        ModConfigSpec.ConfigValue configValue = BUILDER.comment("What you want the introduction message to be for the magic number").define("magicNumberIntroduction", (Object)"The magic number is... ");
        Intrinsics.checkNotNullExpressionValue((Object)configValue, (String)"define(...)");
        MAGIC_NUMBER_INTRODUCTION = configValue;
        ModConfigSpec.ConfigValue configValue2 = BUILDER.comment("A list of items to log on common setup.").defineListAllowEmpty("items", CollectionsKt.listOf((Object)"minecraft:iron_ingot"), INSTANCE::validateItemName);
        Intrinsics.checkNotNullExpressionValue((Object)configValue2, (String)"defineListAllowEmpty(...)");
        ITEM_STRINGS = configValue2;
        ModConfigSpec modConfigSpec = BUILDER.build();
        Intrinsics.checkNotNullExpressionValue((Object)modConfigSpec, (String)"build(...)");
        SPEC = modConfigSpec;
    }
}

