/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.frqnny.mostructures.init.Structures;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class ModStructurePlacement
extends RandomSpreadStructurePlacement {
    public static final MapCodec<ModStructurePlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Vec3i.offsetCodec((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.ZERO).forGetter(rec$ -> ((ModStructurePlacement)((Object)((Object)((Object)rec$)))).locateOffset()), (App)StructurePlacement.FrequencyReductionMethod.CODEC.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(rec$ -> ((ModStructurePlacement)((Object)((Object)((Object)rec$)))).frequencyReductionMethod()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((ModStructurePlacement)((Object)((Object)((Object)rec$)))).frequency())), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(rec$ -> ((ModStructurePlacement)((Object)((Object)((Object)rec$)))).salt()), (App)RegistryFileCodec.create((ResourceKey)Registries.STRUCTURE_SET, (Codec)StructureSet.DIRECT_CODEC, (boolean)false).listOf().fieldOf("structure_set_to_avoid").orElse(new ArrayList(20)).forGetter(config -> config.structureSetToAvoid), (App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(ModStructurePlacement::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(ModStructurePlacement::separation), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(ModStructurePlacement::spreadType)).apply((Applicative)instance, ModStructurePlacement::new));
    public final List<Holder<StructureSet>> structureSetToAvoid;
    private final RandomSpreadType spreadType;
    private int spacing;
    private int separation;
    private boolean activated = true;

    public ModStructurePlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, List<Holder<StructureSet>> structureSetToAvoid, int spacing, int separation, RandomSpreadType spreadType) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, Optional.empty(), spacing, separation, spreadType);
        this.spacing = spacing;
        this.separation = separation;
        this.spreadType = spreadType;
        this.structureSetToAvoid = structureSetToAvoid;
    }

    public static boolean isStructureSetNearby(ChunkGeneratorStructureState calculator, Holder<StructureSet> structureSetEntry, int centerChunkX, int centerChunkZ, int chunkCount) {
        for (int i = centerChunkX - chunkCount; i <= centerChunkX + chunkCount; ++i) {
            for (int j = centerChunkZ - chunkCount; j <= centerChunkZ + chunkCount; ++j) {
                ModStructurePlacement structurePlacement;
                StructurePlacement placement = ((StructureSet)structureSetEntry.value()).placement();
                if (!(placement instanceof ModStructurePlacement ? (structurePlacement = (ModStructurePlacement)placement).shouldGenerateNoExclusionCheck(calculator, i, j) : placement.isStructureChunk(calculator, i, j))) continue;
                return true;
            }
        }
        return false;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public int spacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int separation() {
        return this.separation;
    }

    public void setSeparation(int separation) {
        this.separation = separation;
    }

    public RandomSpreadType spreadType() {
        return this.spreadType;
    }

    public boolean isStructureChunk(ChunkGeneratorStructureState calculator, int chunkX, int chunkZ) {
        return this.activated && super.isStructureChunk(calculator, chunkX, chunkZ) && this.exclusionZoneCheck(calculator, chunkX, chunkZ);
    }

    public boolean shouldGenerateNoExclusionCheck(ChunkGeneratorStructureState calculator, int chunkX, int chunkZ) {
        return this.activated && super.isStructureChunk(calculator, chunkX, chunkZ);
    }

    public boolean exclusionZoneCheck(ChunkGeneratorStructureState calculator, int chunkX, int chunkZ) {
        if (!this.structureSetToAvoid.isEmpty()) {
            for (Holder<StructureSet> entry : this.structureSetToAvoid) {
                if (!ModStructurePlacement.isStructureSetNearby(calculator, entry, chunkX, chunkZ, 4)) continue;
                return false;
            }
        }
        return true;
    }

    public StructurePlacementType<?> type() {
        return (StructurePlacementType)Structures.TYPE.get();
    }
}

