/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.mojang.math.OctahedralGroup;
import commoble.morered.MoreRed;
import commoble.morered.wires.AbstractWireBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WireBlockEntity
extends BlockEntity {
    public static final String POWER = "power";
    protected int[] power = new int[6];

    public WireBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends WireBlockEntity>)((BlockEntityType)MoreRed.get().wireBeType.get()), pos, state);
    }

    public WireBlockEntity(BlockEntityType<? extends WireBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean setPower(int side, int newPower) {
        int oldPower = this.power[side];
        this.power[side] = newPower;
        if (oldPower != newPower) {
            this.setChanged();
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 0);
            return true;
        }
        return false;
    }

    public void setPowerRaw(int[] power) {
        this.power = power;
    }

    public boolean setPower(Direction direction, int newPower) {
        return this.setPower(direction.ordinal(), newPower);
    }

    public int getPower(Direction direction) {
        return this.getPower(direction.ordinal());
    }

    public int getPower(int side) {
        return this.power[side];
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        int[] normalizedPower = new int[6];
        OctahedralGroup normalizer = ((OctahedralGroup)this.getBlockState().getValue(AbstractWireBlock.TRANSFORM)).inverse();
        for (int i = 0; i < 6; ++i) {
            int sidedPower = this.power[i];
            int normalizedIndex = normalizer.rotate(Direction.from3DDataValue((int)i)).ordinal();
            normalizedPower[normalizedIndex] = sidedPower;
        }
        compound.putIntArray(POWER, normalizedPower);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        int[] normalizedPower = compound.getIntArray(POWER);
        if (normalizedPower.length == 6) {
            int[] denormalizedPower = new int[6];
            OctahedralGroup denormalizer = (OctahedralGroup)this.getBlockState().getValue(AbstractWireBlock.TRANSFORM);
            for (int i = 0; i < 6; ++i) {
                int sidedPower = normalizedPower[i];
                int denormalizedIndex = denormalizer.rotate(Direction.from3DDataValue((int)i)).ordinal();
                denormalizedPower[denormalizedIndex] = sidedPower;
            }
            this.power = denormalizedPower;
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag compound = super.getUpdateTag(registries);
        this.saveAdditional(compound, registries);
        return compound;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
        BlockState state = this.getBlockState();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 8);
    }
}

