/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.soldering;

import commoble.morered.MoreRed;
import commoble.morered.soldering.SolderingRecipe;
import commoble.morered.soldering.SolderingResultSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class SolderingMenu
extends AbstractContainerMenu {
    public static final int OUTPUT_SLOT_ID = 0;
    public static final int FIRST_PLAYER_INVENTORY_SLOT_ID = 1;
    public static final int PLAYER_INVENTORY_SLOT_ROWS = 4;
    public static final int PLAYER_INVENTORY_SLOT_COLUMNS = 9;
    public static final int PLAYER_INVENTORY_SLOT_COUNT = 36;
    public static final int FIRST_PLAYER_INVENTORY_HOTBAR_SLOT_ID = 28;
    private final Player player;
    private final ContainerLevelAccess positionInWorld;
    public final ResultContainer craftResult = new ResultContainer();
    @Nullable
    public SolderingRecipe currentRecipe = null;

    public static SolderingMenu getClientContainer(int id, Inventory playerInventory) {
        return new SolderingMenu(id, playerInventory, BlockPos.ZERO);
    }

    public static MenuConstructor getServerContainerProvider(BlockPos pos) {
        return (id, playerInventory, theServerPlayer) -> new SolderingMenu(id, playerInventory, pos);
    }

    protected SolderingMenu(int id, Inventory playerInventory, BlockPos pos) {
        super((MenuType)MoreRed.get().solderingMenuType.get(), id);
        this.player = playerInventory.player;
        this.positionInWorld = ContainerLevelAccess.create((Level)this.player.level(), (BlockPos)pos);
        this.addSlot(new SolderingResultSlot(this, (Container)this.craftResult, 0, 220, 38));
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlot(new Slot((Container)playerInventory, row + column * 9 + 9, 108 + row * 18, 84 + column * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 108 + i * 18, 142));
        }
    }

    public boolean stillValid(Player playerIn) {
        return SolderingMenu.stillValid((ContainerLevelAccess)this.positionInWorld, (Player)playerIn, (Block)((Block)MoreRed.get().solderingTableBlock.get()));
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return false;
    }

    public ItemStack quickMoveStack(Player playerIn, int slotIndex) {
        ItemStack copiedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            copiedStack = stackInSlot.copy();
            if (slotIndex == 0) {
                if (!this.moveItemStackTo(stackInSlot, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stackInSlot, copiedStack);
            } else if (slotIndex >= 1 && (slotIndex < 28 ? !this.moveItemStackTo(stackInSlot, 28, 37, false) : slotIndex >= 28 && slotIndex < 37 && !this.moveItemStackTo(stackInSlot, 1, 28, false))) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stackInSlot.getCount() == copiedStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stackInSlot);
        }
        return copiedStack;
    }

    public void onPlayerChoseRecipe(ResourceLocation recipeID) {
        RecipeHolder<SolderingRecipe> recipe = SolderingMenu.getSolderingRecipe(this.player.level().getRecipeManager(), recipeID);
        if (recipe == null) {
            return;
        }
        this.attemptRecipeAssembly((SolderingRecipe)recipe.value());
    }

    @Nullable
    public static RecipeHolder<SolderingRecipe> getSolderingRecipe(RecipeManager manager, ResourceLocation id) {
        return manager.byKeyTyped((RecipeType)MoreRed.get().solderingRecipeType.get(), id);
    }

    public void attemptRecipeAssembly(@Nullable SolderingRecipe recipe) {
        this.currentRecipe = recipe;
        if (recipe == null || !SolderingRecipe.doesPlayerHaveIngredients(this.player.getInventory(), recipe)) {
            this.craftResult.setItem(0, ItemStack.EMPTY);
        } else {
            this.craftResult.setItem(0, recipe.getResultItem((HolderLookup.Provider)this.player.level().registryAccess()).copy());
        }
    }
}

