/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client.jei;

import commoble.morered.MoreRed;
import commoble.morered.soldering.SolderingRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class SolderingCategory
implements IRecipeCategory<SolderingRecipe> {
    public static final RecipeType<SolderingRecipe> TYPE = RecipeType.create((String)"morered", (String)"soldering", SolderingRecipe.class);
    public static final ResourceLocation CRAFTING_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/crafting_table.png");
    public static final String TITLE = "gui.morered.category.soldering";
    private final IDrawable background;
    private final IDrawable icon;

    public SolderingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MoreRed.get().solderingTableBlock.get()));
        this.background = guiHelper.createDrawable(CRAFTING_TEXTURE, 29, 16, 116, 54);
    }

    public RecipeType<SolderingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)TITLE);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, SolderingRecipe recipe, IFocusGroup focuses) {
        recipeLayout.setShapeless();
        recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        List<SizedIngredient> ingredients = recipe.ingredients();
        int ingredientCount = ingredients.size();
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int inputID = row * 3 + column;
                IRecipeSlotBuilder slot = recipeLayout.addSlot(RecipeIngredientRole.INPUT, column * 18 + 1, row * 18 + 1);
                if (inputID >= ingredientCount) continue;
                slot.addItemStacks(List.of(ingredients.get(inputID).getItems()));
            }
        }
    }
}

