/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.neoforge.SoftFluidImpl;
import net.mehvahdjukaar.moonlight.api.misc.Triplet;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SoftFluid {
    private final Component name;
    private final HolderSet<Fluid> equivalentFluids;
    private final FluidContainerList containerList;
    private final FoodProvider food;
    private final HolderSet<DataComponentType<?>> preservedComponentsFromItem;
    public final boolean isGenerated;
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    @Nullable
    private final ResourceLocation useTexturesFrom;
    private final int luminosity;
    private final int emissivity;
    private final int tintColor;
    private final TintMethod tintMethod;
    protected int averageTextureTint = -1;
    public static final int BOTTLE_COUNT = Capacity.BOTTLE.getValue();
    public static final int BOWL_COUNT = Capacity.BOWL.getValue();
    public static final int BUCKET_COUNT = Capacity.BUCKET.getValue();
    public static final int WATER_BUCKET_COUNT = 3;
    public static final Codec<Holder<SoftFluid>> HOLDER_CODEC = RegistryFileCodec.create(SoftFluidRegistry.KEY, CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<SoftFluid>> STREAM_CODEC = ByteBufCodecs.holderRegistry(SoftFluidRegistry.KEY);
    public static final Codec<Component> COMPONENT_CODEC = Codec.either((Codec)ComponentSerialization.FLAT_CODEC, (Codec)Codec.STRING).xmap(either -> (Component)either.map(c -> c, Component::translatable), Either::left);
    public static final Codec<SoftFluid> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("still_texture").forGetter(SoftFluid::getStillTexture), (App)ResourceLocation.CODEC.fieldOf("flowing_texture").forGetter(SoftFluid::getFlowingTexture), (App)COMPONENT_CODEC.optionalFieldOf("translation_key", (Object)Component.translatable((String)"fluid.moonlight.generic_fluid")).forGetter(SoftFluid::getTranslatedName), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("luminosity", (Object)0).forGetter(SoftFluid::getLuminosity), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("emissivity", (Object)0).forGetter(SoftFluid::getEmissivity), (App)ColorUtils.CODEC.optionalFieldOf("color", (Object)-1).forGetter(SoftFluid::getTintColor), (App)TintMethod.CODEC.optionalFieldOf("tint_method", (Object)TintMethod.STILL_AND_FLOWING).forGetter(SoftFluid::getTintMethod), (App)FoodProvider.CODEC.optionalFieldOf("food", (Object)FoodProvider.EMPTY).forGetter(SoftFluid::getFoodProvider), (App)Utils.lenientHomogeneousList(Registries.DATA_COMPONENT_TYPE).optionalFieldOf("preserved_components_from_item", (Object)HolderSet.empty()).forGetter(SoftFluid::getPreservedComponents), (App)FluidContainerList.CODEC.optionalFieldOf("containers", (Object)new FluidContainerList()).forGetter(SoftFluid::getContainerList), (App)Utils.lenientHomogeneousList(Registries.FLUID).optionalFieldOf("equivalent_fluids", (Object)HolderSet.empty()).forGetter(s -> s.equivalentFluids), (App)ResourceLocation.CODEC.optionalFieldOf("use_texture_from").forGetter(s -> Optional.ofNullable(s.getTextureOverride()))).apply((Applicative)instance, SoftFluid::new));

    protected SoftFluid(ResourceLocation still, ResourceLocation flowing, Component name, int luminosity, int emissivity, int color, TintMethod tintMethod, FoodProvider food, HolderSet<DataComponentType<?>> components, FluidContainerList containers, HolderSet<Fluid> equivalent, Optional<ResourceLocation> textureFrom) {
        Triplet<ResourceLocation, ResourceLocation, Integer> data;
        this.tintMethod = tintMethod;
        this.equivalentFluids = equivalent;
        this.luminosity = luminosity;
        this.emissivity = Math.max(emissivity, luminosity);
        this.containerList = containers;
        this.food = food;
        this.name = name;
        this.preservedComponentsFromItem = components;
        this.useTexturesFrom = textureFrom.orElse(null);
        int tint = color;
        if (this.useTexturesFrom != null && PlatHelper.getPhysicalSide().isClient() && (data = SoftFluid.getRenderingData(this.useTexturesFrom)) != null) {
            still = data.left();
            flowing = data.middle();
            tint = data.right();
        }
        this.stillTexture = still;
        this.flowingTexture = flowing;
        this.tintColor = tint;
        this.isGenerated = false;
    }

    public SoftFluid(Holder<Fluid> fluid) {
        Triplet<ResourceLocation, ResourceLocation, Integer> data;
        ResourceLocation still = ResourceLocation.parse((String)"block/water_still");
        ResourceLocation flowing = ResourceLocation.parse((String)"block/water_flowing");
        this.tintMethod = TintMethod.STILL_AND_FLOWING;
        this.containerList = new FluidContainerList();
        this.food = FoodProvider.EMPTY;
        this.preservedComponentsFromItem = HolderSet.empty();
        this.useTexturesFrom = ((ResourceKey)fluid.unwrapKey().get()).location();
        this.equivalentFluids = HolderSet.direct((Holder[])new Holder[]{fluid});
        Pair<Integer, Component> pair = SoftFluid.getFluidSpecificAttributes((Fluid)fluid.value());
        this.name = pair.getSecond() == null ? Component.literal((String)"generic fluid") : (Component)pair.getSecond();
        this.luminosity = (Integer)pair.getFirst();
        this.emissivity = (Integer)pair.getFirst();
        int tint = -1;
        if (this.useTexturesFrom != null && PlatHelper.getPhysicalSide().isClient() && (data = SoftFluid.getRenderingData(this.useTexturesFrom)) != null) {
            still = data.left();
            flowing = data.middle();
            tint = data.right();
        }
        this.stillTexture = still;
        this.flowingTexture = flowing;
        this.tintColor = tint;
        this.isGenerated = true;
    }

    public void afterInit() {
        for (Holder f : this.equivalentFluids) {
            Item filled = ((Fluid)f.value()).getBucket();
            if (filled == Items.AIR || filled == Items.BUCKET) continue;
            this.containerList.add(Items.BUCKET, filled, BUCKET_COUNT, SoundEvents.BUCKET_FILL, SoundEvents.BUCKET_EMPTY);
        }
    }

    @Nullable
    public ResourceLocation getTextureOverride() {
        return this.useTexturesFrom;
    }

    public FoodProvider getFoodProvider() {
        return this.food;
    }

    public Component getTranslatedName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.equivalentFluids.size() != 0 || !this.containerList.getPossibleFilled().isEmpty();
    }

    public Holder<Fluid> getVanillaFluid() {
        Iterator iterator = this.getEquivalentFluids().iterator();
        if (iterator.hasNext()) {
            Holder fluid = (Holder)iterator.next();
            return fluid;
        }
        return Fluids.EMPTY.builtInRegistryHolder();
    }

    public HolderSet<DataComponentType<?>> getPreservedComponents() {
        return this.preservedComponentsFromItem;
    }

    public HolderSet<Fluid> getEquivalentFluids() {
        return this.equivalentFluids;
    }

    public boolean isEquivalent(Holder<Fluid> fluid) {
        return this.equivalentFluids.contains(fluid);
    }

    @Deprecated(forRemoval=true)
    public boolean isEmptyFluid() {
        return this == SoftFluidRegistry.empty();
    }

    public Optional<Item> getFilledContainer(Item emptyContainer) {
        return this.containerList.getFilled(emptyContainer);
    }

    public Optional<Item> getEmptyContainer(Item filledContainer) {
        return this.containerList.getEmpty(filledContainer);
    }

    public FluidContainerList getContainerList() {
        return this.containerList;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public int getEmissivity() {
        return this.emissivity;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public int getAverageTextureTintColor() {
        return this.averageTextureTint;
    }

    public TintMethod getTintMethod() {
        return this.tintMethod;
    }

    public boolean isColored() {
        return this.tintColor != -1;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public boolean isFood() {
        return !this.food.isEmpty();
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Pair<Integer, Component> getFluidSpecificAttributes(Fluid fluid) {
        return SoftFluidImpl.getFluidSpecificAttributes(fluid);
    }

    @ApiStatus.Internal
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Triplet<ResourceLocation, ResourceLocation, Integer> getRenderingData(ResourceLocation useTexturesFrom) {
        return SoftFluidImpl.getRenderingData(useTexturesFrom);
    }

    public static enum TintMethod implements StringRepresentable
    {
        NO_TINT,
        FLOWING,
        STILL_AND_FLOWING;

        public static final Codec<TintMethod> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean appliesToFlowing() {
            return this == FLOWING || this == STILL_AND_FLOWING;
        }

        public boolean appliesToStill() {
            return this == STILL_AND_FLOWING;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TintMethod::values);
        }
    }

    public static enum Capacity implements StringRepresentable
    {
        BOTTLE(1, 1),
        BOWL(2, 1),
        BUCKET(4, 3),
        BLOCK(4, 4);

        public final int value;
        public static final Codec<Capacity> CODEC;
        public static final Codec<Integer> INT_CODEC;

        private Capacity(int forge, int fabric) {
            this.value = PlatHelper.getPlatform().isForge() ? forge : fabric;
        }

        public String getSerializedName() {
            return this.name().toUpperCase(Locale.ROOT);
        }

        public int getValue() {
            return this.value;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Capacity::values);
            INT_CODEC = Codec.either((Codec)Codec.INT, CODEC).xmap(either -> (Integer)either.map(i -> i, Capacity::getValue), Either::left);
        }
    }
}

