/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.ars;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.data.DominionWandData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import es.degrassi.mmreborn.ars.common.block.prop.SourceHatchSize;
import es.degrassi.mmreborn.ars.common.data.MMRConfig;
import es.degrassi.mmreborn.ars.common.entity.base.SourceHatchEntity;
import es.degrassi.mmreborn.ars.common.registration.EntityRegistration;
import es.degrassi.mmreborn.ars.common.registration.Registration;
import es.degrassi.mmreborn.common.block.prop.ConfigLoaded;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Mod(value="modular_machinery_reborn_ars")
public class ModularMachineryRebornArs {
    public static final String MODID = "modular_machinery_reborn_ars";
    public static final Logger LOGGER = LogManager.getLogger((String)"Modular Machinery Reborn ArsNouveau");

    public ModularMachineryRebornArs(ModContainer CONTAINER, IEventBus MOD_BUS) {
        CONTAINER.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MMRConfig.getSpec());
        Registration.register(MOD_BUS);
        this.addConfig();
        NeoForge.EVENT_BUS.addListener(this::handleWandClick);
        MOD_BUS.addListener(this::registerCapabilities);
    }

    private void addConfig() {
        ConfigLoaded.add(SourceHatchSize.class, size -> size.setSize(MMRConfig.get().sourceSize((SourceHatchSize)size)));
    }

    private void handleWandClick(PlayerInteractEvent.RightClickBlock event) {
        Item item;
        ServerPlayer player;
        Direction side = event.getFace();
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && !(player = (ServerPlayer)player2).isShiftKeyDown() && (item = player.getItemInHand(event.getHand()).getItem()) instanceof DominionWand) {
            DominionWand wand = (DominionWand)item;
            item = player.level().getBlockEntity(event.getPos());
            if (item instanceof SourceHatchEntity) {
                IWandable wandable;
                BlockEntity blockEntity;
                SourceHatchEntity tile = (SourceHatchEntity)item;
                if (tile.getTank() == null) {
                    return;
                }
                ItemStack stack = player.getItemInHand(event.getHand());
                DominionWandData data = (DominionWandData)stack.getOrDefault((DataComponentType)DataComponentRegistry.DOMINION_WAND.get(), (Object)new DominionWandData());
                if (!data.hasStoredData()) {
                    if ((data = data.storePos(new GlobalPos(event.getLevel().dimension(), event.getPos().immutable()))).strict()) {
                        data = data.setFace(event.getFace());
                    }
                    stack.set((DataComponentType)DataComponentRegistry.DOMINION_WAND.get(), (Object)data);
                    PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.dominion_wand.position_set"));
                    event.setCancellationResult(InteractionResult.CONSUME);
                    event.setCanceled(true);
                    return;
                }
                if (data.storedPos().isPresent() && (blockEntity = player.getCommandSenderWorld().getBlockEntity(((GlobalPos)data.storedPos().get()).pos())) instanceof IWandable) {
                    wandable = (IWandable)blockEntity;
                    wandable.onFirstConnection((GlobalPos)data.storedPos().get(), side, (LivingEntity)player.level().getEntity(data.storedEntityId()), (Player)player);
                }
                tile.onLastConnection((GlobalPos)data.storedPos().get(), side, (LivingEntity)player.level().getEntity(data.storedEntityId()), (Player)player);
                tile.getTank().onContentsChanged();
                if (data.storedEntityId() != -1 && (blockEntity = player.level().getEntity(data.storedEntityId())) instanceof IWandable) {
                    wandable = (IWandable)blockEntity;
                    wandable.onFinishedConnectionFirst(event.getPos(), null, (Player)player);
                }
                wand.clear(stack, (Player)player);
                event.setCancellationResult(InteractionResult.CONSUME);
            }
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(CapabilityRegistry.SOURCE_CAPABILITY, EntityRegistration.SOURCE_INPUT_HATCH.get(), (be, side) -> be.getTank());
        event.registerBlockEntity(CapabilityRegistry.SOURCE_CAPABILITY, EntityRegistration.SOURCE_OUTPUT_HATCH.get(), (be, side) -> be.getTank());
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

