/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.util.LoggingLevel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class MMRLogger {
    public static final Logger INSTANCE = ModularMachineryReborn.LOGGER;
    public static final String NAME = "Modular Machinery Reborn";
    private static boolean shouldReset = false;

    public static void init() {
        Appender serverGuiConsole;
        Appender console;
        Appender file;
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        PatternLayout logPattern = PatternLayout.newBuilder().withPattern("[%d{HH:mm:ss.SSS}][%level]: %msg%n%throwable").build();
        TriggeringPolicy policy = new TriggeringPolicy(){

            public void initialize(RollingFileManager manager) {
            }

            public boolean isTriggeringEvent(LogEvent logEvent) {
                if (shouldReset) {
                    shouldReset = false;
                    return true;
                }
                return false;
            }
        };
        RollingFileAppender cmAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName("logs/modular_machinery_reborn/mmr.log").withAppend(false).withFilePattern("logs/modular_machinery_reborn/mmr-%i.log.gz").withPolicy(policy).setName(NAME)).setImmediateFlush(true)).setIgnoreExceptions(false)).setConfiguration(config)).setLayout((Layout)logPattern)).build();
        cmAppender.start();
        config.addAppender((Appender)cmAppender);
        LoggerConfig loggerConfig = LoggerConfig.newBuilder().withAdditivity(false).withLevel(Level.ALL).withLoggerName(NAME).withIncludeLocation("true").withRefs(new AppenderRef[0]).withProperties(null).withConfig(config).withtFilter(null).build();
        loggerConfig.addAppender((Appender)cmAppender, ((LoggingLevel)((Object)MMRConfig.get().debugLevel.get())).getLevel(), null);
        Appender debug = config.getAppender("DebugFile");
        if (debug != null) {
            loggerConfig.addAppender(debug, Level.WARN, null);
        }
        if ((file = config.getAppender("File")) != null) {
            loggerConfig.addAppender(file, Level.WARN, null);
        }
        if ((console = config.getAppender("Console")) != null) {
            loggerConfig.addAppender(console, Level.WARN, null);
        }
        if ((serverGuiConsole = config.getAppender("ServerGuiConsole")) != null) {
            loggerConfig.addAppender(serverGuiConsole, Level.WARN, null);
        }
        config.addLogger(NAME, loggerConfig);
        ctx.updateLoggers();
    }

    public static void reset() {
        shouldReset = true;
    }

    public static void setDebugLevel(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig cmConfig = (LoggerConfig)config.getLoggers().get(NAME);
        if (cmConfig == null) {
            throw new IllegalStateException("Modular Machinery Reborn logger not present!");
        }
        Appender cmAppender = (Appender)cmConfig.getAppenders().get(NAME);
        if (cmAppender == null) {
            throw new IllegalStateException("Modular Machinery Reborn appender not present");
        }
        cmConfig.removeAppender(NAME);
        cmConfig.addAppender(cmAppender, level, null);
    }
}

