/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ItemUtils {
    public static boolean consumeFromInventory(IItemHandlerModifiable handler, ItemStack toConsume, boolean simulate, boolean strict) {
        Map<Integer, ItemStack> contents = ItemUtils.findItemsIndexedInInventory(handler, toConsume, strict);
        if (contents.isEmpty()) {
            return false;
        }
        int cAmt = toConsume.getCount();
        for (int slot : contents.keySet()) {
            ItemStack inSlot;
            int toRemove;
            ItemStack extracted;
            if ((cAmt -= (extracted = handler.extractItem(slot, toRemove = Math.min(cAmt, (inSlot = handler.getStackInSlot(slot)).getCount()), simulate)).getCount()) > 0) continue;
            return true;
        }
        return false;
    }

    public static int tryPlaceItemInInventory(@Nonnull ItemStack stack, IItemHandlerModifiable handler, boolean simulate) {
        return ItemUtils.tryPlaceItemInInventory(stack, handler, 0, handler.getSlots(), simulate);
    }

    public static int tryPlaceItemInInventory(@Nonnull ItemStack stack, IItemHandlerModifiable handler, int start, int end, boolean simulate) {
        ItemStack toAdd = stack.copy();
        if (!ItemUtils.hasInventorySpace(toAdd, (IItemHandler)handler, start, end)) {
            return 0;
        }
        int insertedAmt = 0;
        int max = toAdd.getMaxStackSize();
        for (int i = start; i < end; ++i) {
            ItemStack in = handler.getStackInSlot(i);
            if (in.isEmpty()) {
                int added = Math.min(stack.getCount(), max);
                stack.setCount(stack.getCount() - added);
                if (!simulate) {
                    handler.setStackInSlot(i, ItemUtils.copyStackWithSize(toAdd, added));
                }
                insertedAmt += added;
                if (stack.getCount() > 0) continue;
                return insertedAmt;
            }
            if (!ItemUtils.matchTags(toAdd, in)) continue;
            int space = max - in.getCount();
            int added = Math.min(stack.getCount(), space);
            insertedAmt += added;
            stack.setCount(stack.getCount() - added);
            if (!simulate) {
                handler.setStackInSlot(i, handler.getStackInSlot(i).copyWithCount(handler.getStackInSlot(i).getCount() + added));
            }
            if (stack.getCount() > 0) continue;
            return insertedAmt;
        }
        return insertedAmt;
    }

    public static boolean hasInventorySpace(@Nonnull ItemStack stack, IItemHandler handler, int rangeMin, int rangeMax) {
        int size = stack.getCount();
        int max = stack.getMaxStackSize();
        for (int i = rangeMin; i < rangeMax && size > 0; ++i) {
            ItemStack in = handler.getStackInSlot(i);
            if (in.isEmpty()) {
                size -= max;
                continue;
            }
            if (!ItemUtils.matchTags(stack, in)) continue;
            int space = max - in.getCount();
            size -= space;
        }
        return size <= 0;
    }

    public static boolean stackEqualsNonNBT(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (stack.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (stack.isEmpty() || other.isEmpty()) {
            return false;
        }
        return ItemStack.isSameItem((ItemStack)stack, (ItemStack)other);
    }

    public static boolean matchTags(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        return ItemUtils.stackEqualsNonNBT(stack, other) && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)other);
    }

    @Nonnull
    public static ItemStack copyStackWithSize(@Nonnull ItemStack stack, int amount) {
        if (stack.isEmpty() || amount <= 0) {
            return ItemStack.EMPTY;
        }
        return stack.copyWithCount(amount);
    }

    public static Map<Integer, ItemStack> findItemsIndexedInInventory(IItemHandlerModifiable handler, ItemStack match, boolean strict) {
        HashMap stacksOut = Maps.newHashMap();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (!(strict ? ItemUtils.matchStacks(s, match) : ItemUtils.matchStackLoosely(s, match))) continue;
            stacksOut.put(j, s.copy());
        }
        return stacksOut;
    }

    public static boolean matchStacks(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        return ItemUtils.matchTags(stack, other);
    }

    public static boolean matchStackLoosely(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        return ItemUtils.stackEqualsNonNBT(stack, other);
    }
}

