/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.network.client.emi;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.container.ControllerContainer;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FillRecipeC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<FillRecipeC2SPacket> TYPE = new CustomPacketPayload.Type(ModularMachineryReborn.rl("fill_recipe_mmr"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FillRecipeC2SPacket> CODEC = StreamCodec.ofMember(FillRecipeC2SPacket::write, FillRecipeC2SPacket::new);
    private final int syncId;
    private final int action;
    private final List<Integer> slots;
    private final List<Integer> crafting;
    private final int output;
    private final List<ItemStack> stacks;

    public FillRecipeC2SPacket(AbstractContainerMenu handler, int action, List<Slot> slots, List<Slot> crafting, @Nullable Slot output, List<ItemStack> stacks) {
        this.syncId = handler.containerId;
        this.action = action;
        this.slots = slots.stream().map(s -> s == null ? -1 : s.index).toList();
        this.crafting = crafting.stream().map(s -> s == null ? -1 : s.index).toList();
        this.output = output == null ? -1 : output.index;
        this.stacks = stacks;
    }

    public FillRecipeC2SPacket(RegistryFriendlyByteBuf buf) {
        this.syncId = buf.readInt();
        this.action = buf.readByte();
        this.slots = FillRecipeC2SPacket.parseCompressedSlots((FriendlyByteBuf)buf);
        this.crafting = Lists.newArrayList();
        int craftingSize = buf.readVarInt();
        for (int i = 0; i < craftingSize; ++i) {
            int s = buf.readVarInt();
            this.crafting.add(s);
        }
        this.output = buf.readBoolean() ? buf.readVarInt() : -1;
        int size = buf.readVarInt();
        this.stacks = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            this.stacks.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
        }
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.syncId);
        buf.writeByte(this.action);
        FillRecipeC2SPacket.writeCompressedSlots(this.slots, (FriendlyByteBuf)buf);
        buf.writeVarInt(this.crafting.size());
        for (Integer s : this.crafting) {
            buf.writeVarInt(s.intValue());
        }
        if (this.output != -1) {
            buf.writeBoolean(true);
            buf.writeVarInt(this.output);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeVarInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)stack);
        }
    }

    public void apply(Player player) {
        if (this.slots == null || this.crafting == null) {
            ModularMachineryReborn.LOGGER.error("Client requested fill but passed input and crafting slot information was invalid, aborting");
            return;
        }
        AbstractContainerMenu h = player.containerMenu;
        if (!(h instanceof ControllerContainer)) {
            ModularMachineryReborn.LOGGER.warn("Client requested fill but screen handler has changed, aborting");
            return;
        }
        ControllerContainer handler = (ControllerContainer)h;
        if (handler.containerId != this.syncId) {
            ModularMachineryReborn.LOGGER.warn("Client requested fill but screen handler has changed, aborting");
            return;
        }
        ((MachineControllerEntity)handler.getEntity()).getComponentManager().getComponent(ComponentRegistration.COMPONENT_ITEM.get(), IOType.INPUT).map(c -> (ItemComponent)c).map(ItemComponent::getContainerProvider).ifPresent(inventory -> {
            List<Slot> slots = inventory.createSlots(player);
            List<Slot> crafting = inventory.createInventorySlots(Lists.newArrayList(), 0);
            AtomicReference<Object> output = new AtomicReference<Object>(null);
            if (this.output != -1) {
                ((MachineControllerEntity)handler.getEntity()).getComponentManager().getComponent(ComponentRegistration.COMPONENT_ITEM.get(), IOType.OUTPUT).map(c -> (ItemComponent)c).map(ItemComponent::getContainerProvider).ifPresent(outInv -> {
                    if (this.output >= 0 && this.output < outInv.getSlots()) {
                        output.set(outInv.createInventorySlots(Lists.newArrayList(), 0).get(this.output));
                    }
                });
            }
            if (crafting.size() >= this.stacks.size()) {
                ArrayList rubble = Lists.newArrayList();
                for (Slot slot : crafting) {
                    if (slot == null || slot.getItem().isEmpty()) continue;
                    rubble.add(slot.getItem().copy());
                    inventory.setStackInSlot(slot.getSlotIndex(), ItemStack.EMPTY);
                }
                try {
                    for (int i = 0; i < this.stacks.size(); ++i) {
                        ItemStack stack = this.stacks.get(i);
                        if (stack.isEmpty()) continue;
                        int gotten = FillRecipeC2SPacket.grabMatching(player, inventory, slots, rubble, crafting, stack);
                        if (gotten != stack.getCount()) {
                            if (gotten <= 0) continue;
                            stack.setCount(gotten);
                            player.getInventory().placeItemBackInInventory(stack);
                            continue;
                        }
                        Slot slot = crafting.get(i);
                        if (slot != null && stack.getCount() <= inventory.getSlotLimit(slot.getSlotIndex())) {
                            inventory.setStackInSlot(slot.getSlotIndex(), stack);
                            continue;
                        }
                        player.getInventory().placeItemBackInInventory(stack);
                    }
                    if (output.get() != null) {
                        if (this.action == 1) {
                            handler.clicked(((Slot)output.get()).getSlotIndex(), 0, ClickType.PICKUP, player);
                        } else if (this.action == 2) {
                            handler.clicked(((Slot)output.get()).getSlotIndex(), 0, ClickType.QUICK_MOVE, player);
                        }
                    }
                }
                finally {
                    for (ItemStack stack : rubble) {
                        player.getInventory().placeItemBackInInventory(stack);
                    }
                }
            }
        });
    }

    private static List<Integer> parseCompressedSlots(FriendlyByteBuf buf) {
        ArrayList list = Lists.newArrayList();
        int amount = buf.readVarInt();
        for (int i = 0; i < amount; ++i) {
            int low = buf.readVarInt();
            int high = buf.readVarInt();
            if (low < 0) {
                return null;
            }
            for (int j = low; j <= high; ++j) {
                list.add(j);
            }
        }
        return list;
    }

    private static void writeCompressedSlots(List<Integer> list, FriendlyByteBuf buf) {
        ArrayList postWrite = Lists.newArrayList();
        int groups = 0;
        int i = 0;
        while (i < list.size()) {
            ++groups;
            int start = i;
            int startValue = list.get(start);
            while (i < list.size() && i - start == list.get(i) - startValue) {
                ++i;
            }
            int end = i - 1;
            postWrite.add(b -> {
                b.writeVarInt(startValue);
                b.writeVarInt(((Integer)list.get(end)).intValue());
            });
        }
        buf.writeVarInt(groups);
        for (Consumer consumer : postWrite) {
            consumer.accept(buf);
        }
    }

    private static int grabMatching(Player player, IOInventory inventory, List<Slot> slots, List<ItemStack> rubble, List<Slot> crafting, ItemStack stack) {
        int amount = stack.getCount();
        int grabbed = 0;
        for (int i = 0; i < rubble.size(); ++i) {
            if (grabbed >= amount) {
                return grabbed;
            }
            ItemStack r = rubble.get(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)r)) continue;
            int wanted = amount - grabbed;
            if (r.getCount() <= wanted) {
                grabbed += r.getCount();
                rubble.remove(i);
                --i;
                continue;
            }
            grabbed = amount;
            r.setCount(r.getCount() - wanted);
        }
        for (Slot s : slots) {
            ItemStack st;
            if (grabbed >= amount) {
                return grabbed;
            }
            if (crafting.contains(s) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(st = s.getItem()))) continue;
            int wanted = amount - grabbed;
            ItemStack taken = st.copy();
            if (st.getCount() <= wanted) {
                grabbed += st.getCount();
                inventory.setStackInSlot(s.getSlotIndex(), ItemStack.EMPTY);
                continue;
            }
            grabbed = amount;
            st.setCount(st.getCount() - wanted);
        }
        return grabbed;
    }

    @NotNull
    public CustomPacketPayload.Type<FillRecipeC2SPacket> type() {
        return TYPE;
    }

    public String toString() {
        return "FillRecipeC2SPacket{syncId=" + this.syncId + ", action=" + this.action + ", slots=" + String.valueOf(this.slots) + ", crafting=" + String.valueOf(this.crafting) + ", output=" + this.output + ", stacks=" + String.valueOf(this.stacks) + "}";
    }

    public static void handle(FillRecipeC2SPacket packet, IPayloadContext context) {
        if (!context.flow().isServerbound()) {
            throw new IllegalArgumentException("Trying to handle serverbound packet on client: " + String.valueOf(packet));
        }
        Player player = context.player();
        context.enqueueWork(() -> packet.apply(player));
    }
}

