/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import es.degrassi.mmreborn.common.crafting.modifier.RecipeModifier;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.ParallelHatchEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TileItemBus;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.machine.component.FunctionComponent;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.machine.component.ParallelComponent;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.INBTSerializable;

@ParametersAreNonnullByDefault
public class ComponentManager
implements INBTSerializable<CompoundTag>,
ISyncableStuff {
    private final MachineControllerEntity controller;
    private final Map<BlockPos, MachineComponent<?>> foundComponents = Maps.newHashMap();
    private final Map<ComponentType, Map<IOType, List<MachineComponent<?>>>> foundComponentsValues = Maps.newHashMap();
    private final Map<BlockPos, List<ModifierReplacement>> foundModifiers = Maps.newHashMap();
    private final long tickOffset = Utils.RAND.nextLong(0L, Long.MAX_VALUE);
    private long lastComponentsCheckTick;
    private long lastModifiersCheckTick;

    public ComponentManager(MachineControllerEntity entity) {
        this.controller = entity;
    }

    public final void reset() {
        this.foundComponents.clear();
        this.foundModifiers.clear();
        this.foundComponentsValues.clear();
    }

    public final void updateModifiers(boolean force) {
        if (this.controller.getFoundMachine() == DynamicMachine.DUMMY) {
            return;
        }
        Level level = this.controller.getLevel();
        if (level == null) {
            return;
        }
        long gameTime = level.getGameTime();
        if (!Utils.shouldRunPeriodicCheck(force, gameTime, this.lastModifiersCheckTick, this.tickOffset, ((Integer)MMRConfig.get().checkStructureTicks.get()).intValue())) {
            return;
        }
        this.lastModifiersCheckTick = gameTime;
        this.foundModifiers.clear();
        this.foundModifiers.putAll(this.gatherModifiers());
        this.controller.setChanged();
    }

    public final void updateComponents(boolean force) {
        if (this.controller.getFoundMachine() == DynamicMachine.DUMMY) {
            return;
        }
        Level level = this.controller.getLevel();
        if (level == null) {
            return;
        }
        long gameTime = level.getGameTime();
        if (!Utils.shouldRunPeriodicCheck(force, gameTime, this.lastComponentsCheckTick, this.tickOffset, ((Integer)MMRConfig.get().checkStructureTicks.get()).intValue())) {
            return;
        }
        this.lastComponentsCheckTick = gameTime;
        this.reset();
        this.foundComponents.putAll(this.gatherComponents());
        this.foundComponentsValues.putAll(this.filter());
        this.updateModifiers(force);
        this.controller.getProcessor().setMachineInventoryChanged();
        this.controller.setChanged();
    }

    private Map<ComponentType, Map<IOType, List<MachineComponent<?>>>> filter() {
        HashMap foundComponentsValues = Maps.newHashMap();
        for (MachineComponent<?> comp : this.foundComponents.values()) {
            foundComponentsValues.computeIfAbsent(comp.getComponentType(), t -> Maps.newHashMap()).computeIfAbsent(comp.getIOType(), io -> Lists.newArrayList()).add(comp);
        }
        return foundComponentsValues;
    }

    public final List<MachineComponent<?>> getFoundComponentsList() {
        if (this.foundComponents.isEmpty()) {
            this.updateComponents(true);
        }
        return this.foundComponents.values().stream().toList();
    }

    public List<ModifierReplacement> getFoundModifiersList() {
        if (this.foundModifiers.isEmpty()) {
            this.updateComponents(true);
        }
        return this.foundModifiers.values().stream().flatMap(Collection::stream).toList();
    }

    public final Map<BlockPos, MachineComponent<?>> getFoundComponentsMap() {
        return this.foundComponents;
    }

    public final Map<BlockPos, List<ModifierReplacement>> getFoundModifiersMap() {
        return this.foundModifiers;
    }

    private Map<BlockPos, MachineComponent<?>> gatherComponents() {
        HashMap map = Maps.newHashMap();
        Map<BlockPos, BlockIngredient> filteredMap = this.controller.getFoundMachine().getPattern().getBlocksFiltered((Direction)this.controller.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        BlockPos controllerPos = this.controller.getBlockPos();
        Level level = this.controller.getLevel();
        if (level == null) {
            return map;
        }
        for (BlockPos potentialPosition : filteredMap.keySet()) {
            BlockPos realPos = controllerPos.offset((Vec3i)potentialPosition);
            BlockEntity te = level.getBlockEntity(realPos);
            if (!(te instanceof MachineComponentEntity)) continue;
            MachineComponentEntity entity = (MachineComponentEntity)te;
            Object component = entity.provideComponent();
            if (entity instanceof ControllerAccessible) {
                ControllerAccessible accessible = (ControllerAccessible)((Object)entity);
                if (accessible.getControllerPos() == null) {
                    accessible.setControllerPos(controllerPos.immutable());
                }
                if (component == null || !controllerPos.equals((Object)accessible.getControllerPos())) continue;
                map.put(realPos, component);
                continue;
            }
            map.put(realPos, component);
        }
        map.put(controllerPos, new FunctionComponent(controllerPos));
        return map;
    }

    private Map<BlockPos, List<ModifierReplacement>> gatherModifiers() {
        HashMap map = Maps.newHashMap();
        if (this.controller.getLevel() == null) {
            return map;
        }
        this.controller.getFoundMachine().getPattern().getPattern().getModifiers((Direction)this.controller.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).forEach((potentialPosition, modifiers) -> {
            BlockPos realPos = this.controller.getBlockPos().offset((Vec3i)potentialPosition);
            BlockInWorld biw = new BlockInWorld((LevelReader)this.controller.getLevel(), realPos, false);
            if (modifiers.stream().anyMatch(modifier -> modifier.getIngredient().getAll().stream().anyMatch(state -> state.test(biw)))) {
                map.put(realPos, modifiers);
            }
        });
        return map;
    }

    public List<RecipeModifier> getModifiers(RequirementType<?> type) {
        if (this.foundModifiers.isEmpty() && !this.getController().getFoundMachine().getModifiers().isEmpty()) {
            this.updateModifiers(false);
        }
        return this.foundModifiers.values().stream().flatMap(Collection::stream).map(ModifierReplacement::getModifiers).flatMap(Collection::stream).filter(mod -> mod.getRequirementType().equals(type)).toList();
    }

    public <C extends MachineComponent<?>> Optional<C> getComponent(IRequirement<C> requirement, ICraftingContext context) {
        if (this.foundComponentsValues.isEmpty()) {
            this.updateComponents(true);
        }
        AtomicReference<Object> merged = new AtomicReference<Object>(null);
        Optional.ofNullable(this.foundComponentsValues.get(requirement.getComponentType())).map(m -> (List)m.get((Object)requirement.getMode())).stream().flatMap(Collection::stream).map(m -> m).filter(Objects::nonNull).filter(m -> requirement.test(m, context) || requirement.isComponentValid(m, context)).sorted().forEach(c -> {
            if (merged.get() == null) {
                merged.set(c);
            }
            if (((MachineComponent)merged.get()).canMerge(c)) {
                merged.set(((MachineComponent)merged.get()).merge(c));
            }
        });
        return Optional.ofNullable(merged.get());
    }

    public Optional<ParallelComponent> getParallel() {
        Map<BlockPos, BlockIngredient> filteredMap = this.controller.getFoundMachine().getPattern().getBlocksFiltered((Direction)this.controller.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        BlockPos controllerPos = this.controller.getBlockPos();
        Level level = this.controller.getLevel();
        if (level == null) {
            return Optional.empty();
        }
        for (BlockPos potentialPosition : filteredMap.keySet()) {
            BlockPos realPos = controllerPos.offset((Vec3i)potentialPosition);
            try {
                BlockEntity blockEntity = level.getBlockEntity(realPos);
                if (!(blockEntity instanceof ParallelHatchEntity)) continue;
                ParallelHatchEntity entity = (ParallelHatchEntity)blockEntity;
                return Optional.of(entity.provideComponent());
            }
            catch (Exception exception) {
            }
        }
        return Optional.empty();
    }

    public Optional<ItemComponent> getItemComponent(IOType mode) {
        Map<BlockPos, BlockIngredient> filteredMap = this.controller.getFoundMachine().getPattern().getBlocksFiltered((Direction)this.controller.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        BlockPos controllerPos = this.controller.getBlockPos();
        Level level = this.controller.getLevel();
        if (level == null) {
            return Optional.empty();
        }
        ArrayList components = Lists.newArrayList();
        for (BlockPos potentialPosition : filteredMap.keySet()) {
            BlockPos realPos = controllerPos.offset((Vec3i)potentialPosition);
            try {
                TileItemBus entity;
                BlockEntity blockEntity = level.getBlockEntity(realPos);
                if (!(blockEntity instanceof TileItemBus) || !(entity = (TileItemBus)blockEntity).getIoType().equals((Object)mode) || entity.provideComponent() == null) continue;
                components.add(entity.provideComponent());
            }
            catch (Exception exception) {}
        }
        if (components.isEmpty()) {
            return Optional.empty();
        }
        AtomicReference<Object> merged = new AtomicReference<Object>(null);
        components.stream().filter(Objects::nonNull).sorted().forEach(c -> {
            if (merged.get() == null) {
                merged.set(c);
            } else if (((ItemComponent)merged.get()).canMerge(c)) {
                merged.set(((ItemComponent)merged.get()).merge(c));
            }
        });
        return Optional.ofNullable(merged.get());
    }

    public <C extends MachineComponent<?>> Optional<C> getComponent(ComponentType type, IOType mode) {
        if (this.foundComponentsValues.isEmpty()) {
            this.updateComponents(true);
        }
        AtomicReference<Object> merged = new AtomicReference<Object>(null);
        Optional.ofNullable(this.foundComponentsValues.get(type)).map(m -> (List)m.get((Object)mode)).stream().flatMap(Collection::stream).map(m -> m).filter(Objects::nonNull).sorted().forEach(c -> {
            if (merged.get() == null) {
                merged.set(c);
            } else if (((MachineComponent)merged.get()).canMerge(c)) {
                merged.set(((MachineComponent)merged.get()).merge(c));
            }
        });
        return Optional.ofNullable(merged.get());
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag componentsByType = new CompoundTag();
        this.foundComponentsValues.forEach((type, map) -> {
            CompoundTag listByMode = new CompoundTag();
            map.forEach((mode, list) -> listByMode.put(mode.getSerializedName(), (Tag)this.getComponent((ComponentType)type, (IOType)((Object)((Object)mode))).map(component -> component.asTag(provider)).orElse(new CompoundTag())));
            componentsByType.put(type.getId().toString(), (Tag)listByMode);
        });
        nbt.put("components", (Tag)componentsByType);
        ListTag modifiers = new ListTag();
        this.foundModifiers.forEach((pos, list) -> {
            ListTag mods = list.stream().map(ModifierReplacement::asTag).collect(ListTag::new, AbstractList::add, AbstractList::add);
            CompoundTag mod = new CompoundTag();
            CompoundTag position = new CompoundTag();
            position.putInt("x", pos.getX());
            position.putInt("y", pos.getY());
            position.putInt("z", pos.getZ());
            mod.put("position", (Tag)position);
            mod.put("modifiers", (Tag)mods);
            modifiers.add((Object)mod);
        });
        nbt.put("modifiers", (Tag)modifiers);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.updateComponents(true);
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        this.getFoundComponentsList().stream().filter(c -> c instanceof ISyncableStuff).map(c -> (ISyncableStuff)((Object)c)).forEach(c -> c.getStuffToSync(container));
    }

    @Generated
    public MachineControllerEntity getController() {
        return this.controller;
    }
}

