/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.integration.kubejs.KubeJSIntegration;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.MachineLocation;
import es.degrassi.mmreborn.common.util.CustomJsonReloadListener;
import es.degrassi.mmreborn.common.util.MMRLogger;
import java.io.IOException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.ICondition;

public class MachineJsonReloadListener
extends CustomJsonReloadListener {
    private static final String MAIN_PACKNAME = "main";
    public static ICondition.IContext context;

    public MachineJsonReloadListener() {
        super((String)MMRConfig.get().machineDirectory.get());
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        MMRLogger.INSTANCE.info("Reading Modular Machinery Reborn Machines...");
        ModularMachineryReborn.MACHINES.clear();
        context = this.getContext();
        map.forEach((id, json) -> {
            MachineLocation location = this.getMachineLocation(resourceManager, (ResourceLocation)id);
            MMRLogger.INSTANCE.info("Parsing machine json: {} in datapack: {}", id, (Object)location.getPackName());
            if (!json.isJsonObject()) {
                MMRLogger.INSTANCE.error("Bad machine JSON: {} must be a json object and not an array or primitive, skipping...", id);
                return;
            }
            if (ModularMachineryReborn.MACHINES.containsKey(id)) {
                MMRLogger.INSTANCE.error("A machine with id: {} already exists, skipping...", id);
                return;
            }
            DataResult<DynamicMachine> result = DynamicMachine.CODEC.read(JsonOps.INSTANCE, json);
            if (result.result().isPresent()) {
                DynamicMachine machine = (DynamicMachine)result.result().get();
                machine.setRegistryName((ResourceLocation)id);
                ModularMachineryReborn.MACHINES.put((Object)machine.getRegistryName(), (Object)machine);
                MMRLogger.INSTANCE.info("Successfully parsed machine json: {}", (Object)machine.getRegistryName());
            } else if (result.error().isPresent()) {
                MMRLogger.INSTANCE.error("Error while parsing machine json: {}, skipping...\n{}", id, (Object)((DataResult.Error)result.error().get()).message());
            }
        });
        if (ModList.get().isLoaded("kubejs")) {
            MMRLogger.INSTANCE.info("Collecting machines with kubeJS.");
            Map<ResourceLocation, DynamicMachine> kubejsMachines = KubeJSIntegration.collectMachines();
            if (!kubejsMachines.isEmpty()) {
                MMRLogger.INSTANCE.info("Successfully added {} machines with kubejs", (Object)kubejsMachines.size());
            } else {
                MMRLogger.INSTANCE.info("No machines found with kubejs");
            }
            ModularMachineryReborn.MACHINES.putAll(kubejsMachines);
        }
        context = null;
        MMRLogger.INSTANCE.info("Finished creating {} modular machines.", (Object)ModularMachineryReborn.MACHINES.keySet().size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MachineLocation getMachineLocation(ResourceManager resourceManager, ResourceLocation id) {
        ResourceLocation path = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("machines/" + id.getPath() + ".json"));
        try {
            Resource res = resourceManager.getResourceOrThrow(path);
            String packName = res.sourcePackId();
            if (packName.equals(MAIN_PACKNAME)) {
                return MachineLocation.fromDefault(id, packName);
            }
            if (packName.contains("KubeJS") && ModList.get().isLoaded("kubejs")) {
                return KubeJSIntegration.getMachineLocation(res, packName, id);
            }
            try (PackResources pack = res.source();){
                if (pack instanceof FilePackResources) {
                    MachineLocation machineLocation = MachineLocation.fromDatapackZip(id, packName);
                    return machineLocation;
                }
                if (!(pack instanceof PathPackResources)) return MachineLocation.fromDefault(id, MAIN_PACKNAME);
                MachineLocation machineLocation = MachineLocation.fromDatapack(id, packName);
                return machineLocation;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return MachineLocation.fromDefault(id, MAIN_PACKNAME);
    }
}

