/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.event.KubeEvent;
import es.degrassi.mmreborn.api.Structure;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.integration.kubejs.builder.ModifierBuilderJS;
import es.degrassi.mmreborn.common.integration.kubejs.builder.StructureBuilderJS;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.Sounds;
import es.degrassi.mmreborn.common.manager.crafting.MachineStatus;
import es.degrassi.mmreborn.common.util.MachineModelLocation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MachineBuilderJS {
    @NotNull
    private final ResourceLocation id;
    private String name;
    private String color;
    private Integer intColor;
    private StructureBuilderJS structure;
    private MachineModelLocation controllerModel;
    private final List<ModifierReplacement> modifiers;
    private final Map<MachineStatus, Sounds> sounds;

    public MachineBuilderJS(@NotNull ResourceLocation id) {
        this.id = id;
        this.modifiers = Lists.newArrayList();
        this.sounds = Maps.newEnumMap(MachineStatus.class);
    }

    public MachineBuilderJS name(String name) {
        this.name = name;
        return this;
    }

    public MachineBuilderJS color(String color) {
        this.color = color;
        return this;
    }

    public MachineBuilderJS color(Integer color) {
        this.intColor = color;
        return this;
    }

    public MachineBuilderJS structure(StructureBuilderJS structure) {
        this.structure = structure;
        return this;
    }

    public MachineBuilderJS controllerModel(MachineModelLocation modelLocation) {
        this.controllerModel = modelLocation;
        return this;
    }

    public MachineBuilderJS addModifier(ModifierBuilderJS modifier) {
        this.modifiers.add(modifier.build());
        return this;
    }

    public MachineBuilderJS sound(MachineStatus status, Sounds sounds) {
        this.sounds.put(status, sounds);
        return this;
    }

    public DynamicMachine build() {
        DynamicMachine machine = new DynamicMachine(this.id, this.sounds);
        machine.setPattern(this.structure == null ? Structure.EMPTY : this.structure.build(this.modifiers));
        machine.setControllerModel(Objects.requireNonNullElse(this.controllerModel, MachineModelLocation.DEFAULT));
        machine.setLocalizedName(Optional.ofNullable(this.name));
        if (this.intColor != null) {
            machine.setDefinedColor(this.intColor);
        } else if (this.color != null) {
            machine.setDefinedColor((Integer)DefaultCodecs.HEX.decode(JsonOps.INSTANCE, new JsonPrimitive(this.color)).result().orElse(new Pair((Object)Config.toInt((String)MMRConfig.get().general_casing_color.get(), 16730368), null)).getFirst());
        }
        return machine;
    }

    @NotNull
    @Generated
    public ResourceLocation getId() {
        return this.id;
    }

    public static class MachineKubeEvent
    implements KubeEvent {
        private final List<MachineBuilderJS> builders = Lists.newArrayList();

        public MachineBuilderJS create(ResourceLocation id) {
            MachineBuilderJS builder = new MachineBuilderJS(id);
            this.builders.add(builder);
            return builder;
        }

        @Generated
        public List<MachineBuilderJS> getBuilders() {
            return this.builders;
        }
    }
}

