/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.jei.category;

import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementDuration;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiDurationComponent;
import es.degrassi.mmreborn.common.integration.jei.JeiComponentRegistry;
import es.degrassi.mmreborn.common.integration.jei.MMRJeiPlugin;
import es.degrassi.mmreborn.common.integration.jei.category.drawable.DrawableWrappedText;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.component.DurationComponent;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import es.degrassi.mmreborn.common.registration.Registration;
import lombok.Generated;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.placement.IPlaceable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMRRecipeCategory
implements IRecipeCategory<MachineRecipe> {
    private DynamicMachine machine;
    private final String title;
    private final IDrawable background;
    private final IDrawable icon;
    public final int initialX = 8;
    public final int gap = 8;
    protected int width = 256;
    protected int height = 256;

    public MMRRecipeCategory(DynamicMachine machine) {
        this.machine = machine;
        this.title = machine.getLocalizedName();
        this.background = MMRJeiPlugin.jeiHelpers.getGuiHelper().createBlankDrawable(256, 256);
        ItemStack stack = new ItemStack((ItemLike)ItemRegistration.CONTROLLER.get());
        stack.set(Registration.MACHINE_DATA, (Object)machine.getRegistryName());
        this.icon = MMRJeiPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
    }

    public void updateMachine(DynamicMachine machine) {
        this.machine = machine;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public RecipeType<MachineRecipe> getRecipeType() {
        return RecipeType.create((String)this.machine.getRegistryName().getNamespace(), (String)this.machine.getRegistryName().getPath(), MachineRecipe.class);
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)this.title);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, MachineRecipe recipe, @NotNull IFocusGroup focuses) {
        this.width = recipe.getWidth();
        this.height = recipe.getHeight();
        recipe.textsToRender.clear();
        recipe.chanceTexts.clear();
        if (recipe.isShouldRenderProgress()) {
            new JeiDurationComponent(new RecipeRequirement<DurationComponent, RequirementDuration>(new RequirementDuration(recipe.getRecipeTotalTickTime(), recipe.getProgressPosition()), 1.0f), 20, IDrawableAnimated.StartDirection.LEFT).setRecipe(this, builder, recipe, focuses);
        }
        recipe.getRequirements().stream().filter(component -> JeiComponentRegistry.hasJeiComponent(component.getType())).map(requirement -> requirement.castRequirement((RecipeRequirement<?, ?>)requirement)).map(component -> JeiComponentRegistry.getJeiComponent(component.getType()).create((RecipeRequirement)component)).forEach(requirement -> requirement.setRecipe(this, builder, recipe, focuses));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, @NotNull MachineRecipe recipe, @NotNull IFocusGroup focuses) {
        IPlaceable text = builder.addDrawable((IDrawable)new DrawableWrappedText(Lists.newArrayList(recipe.textsToRender.iterator()), recipe.getWidth() - 8, false));
        text.setPosition(8, recipe.getHeight() - 8 - text.getHeight());
        recipe.chanceTexts.stream().map(Pair::getSecond).map(DrawableWrappedText.class::cast).forEach(arg_0 -> ((IRecipeExtrasBuilder)builder).addDrawable(arg_0));
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }
}

