/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.jade;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.manager.crafting.MachineProcessorCore;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public class DynamicMachineServerDataProvider
implements IServerDataProvider<BlockAccessor> {
    public static final DynamicMachineServerDataProvider INSTANCE = new DynamicMachineServerDataProvider();
    public static final ResourceLocation ID = ModularMachineryReborn.rl("machine_server_data_provider");

    public void appendServerData(CompoundTag nbt, BlockAccessor accessor) {
        MachineControllerEntity machine;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof MachineControllerEntity && (machine = (MachineControllerEntity)blockEntity).getLevel() != null) {
            CompoundTag tag = new CompoundTag();
            if (machine.isPaused()) {
                tag.putBoolean("paused", true);
            } else {
                tag.put("status", (Tag)machine.getCraftingStatus().serializeNBT((HolderLookup.Provider)accessor.getLevel().registryAccess()));
                tag.putLong("runningCores", machine.getProcessor().cores().stream().filter(MachineProcessorCore::isActive).filter(MachineProcessorCore::hasActiveRecipe).count());
            }
            nbt.put("modular_machinery_reborn", (Tag)tag);
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

