/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import es.degrassi.experiencelib.impl.capability.BasicExperienceTank;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.common.block.prop.ExperienceHatchSize;
import es.degrassi.mmreborn.common.entity.ExperienceInputHatchEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.ExperienceComponent;
import es.degrassi.mmreborn.common.network.server.component.SUpdateExperienceComponentPacket;
import java.util.Locale;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class ExperienceHatchEntity
extends ColorableMachineComponentEntity
implements MachineComponentEntity<ExperienceComponent>,
ControllerAccessible {
    protected ExperienceHatchSize size;
    protected IOType ioType;
    private BlockPos controllerPos;
    private final BasicExperienceTank experienceTank;

    public ExperienceHatchEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ExperienceHatchSize size, IOType ioType) {
        super(type, pos, state);
        this.size = size;
        this.ioType = ioType;
        this.experienceTank = this.buildTank();
    }

    public BasicExperienceTank getTank() {
        return this.experienceTank;
    }

    @Override
    @Nullable
    public ExperienceComponent provideComponent() {
        return new ExperienceComponent((IExperienceHandler)this.getTank(), this.ioType);
    }

    private BasicExperienceTank buildTank() {
        return new BasicExperienceTank(this.size == null ? 0L : (long)this.size.getCapacity(), () -> {
            if (this.getLevel() != null && !this.getLevel().isClientSide) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.getLevel()), (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateExperienceComponentPacket(this.getTank().getExperience(), this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (this.getController() != null) {
                this.getController().getProcessor().setMachineInventoryChanged();
            }
        }){

            public boolean canExtract() {
                return ExperienceHatchEntity.this.ioType == null || !ExperienceHatchEntity.this.ioType.isInput();
            }

            public boolean canReceive() {
                return ExperienceHatchEntity.this.ioType == null || ExperienceHatchEntity.this.ioType.isInput();
            }

            public boolean canAcceptExperience(long l) {
                return this.canReceive() && this.receiveExperience(l, true) > 0L;
            }

            public boolean canProvideExperience(long l) {
                return this.canExtract() && this.extractExperience(l, true) > 0L;
            }

            public long getMaxExtract() {
                return this.canExtract() ? this.getExperienceCapacity() : 0L;
            }

            public long getMaxReceive() {
                return this.canReceive() ? this.getExperienceCapacity() : 0L;
            }
        };
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.size = ExperienceHatchSize.value(compound.getString("hatchSize").toUpperCase(Locale.ROOT));
        this.ioType = IOType.getByString(compound.getString("ioType"));
        if (compound.contains("experience", 10)) {
            this.experienceTank.deserializeNBT(pRegistries, compound.getCompound("experience"));
        }
        this.experienceTank.setCapacity((long)this.size.getCapacity());
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putString("hatchSize", this.size.getSerializedName());
        if (this.ioType == null) {
            this.ioType = this instanceof ExperienceInputHatchEntity ? IOType.INPUT : IOType.OUTPUT;
        }
        compound.putString("ioType", this.ioType.getSerializedName());
        compound.put("experience", (Tag)this.experienceTank.serializeNBT(pRegistries));
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }
}

