/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.entity.base.BlockEntitySynchronized;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineEntity;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineColorPacket;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ColorableMachineComponentEntity
extends BlockEntitySynchronized
implements ColorableMachineEntity {
    private int definedColor = Config.machineColor;

    public ColorableMachineComponentEntity(BlockPos pos, BlockState blockState) {
        super(EntityRegistration.COLORABLE_MACHINE.get(), pos, blockState);
    }

    public ColorableMachineComponentEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState blockState) {
        super(entityType, pos, blockState);
    }

    @Override
    public int getMachineColor() {
        return this.definedColor;
    }

    @Override
    public void setMachineColor(int newColor) {
        this.setChanged();
        this.definedColor = newColor;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineColorPacket(newColor, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        if (nbt.contains("casingColor")) {
            this.definedColor = nbt.getInt("casingColor");
            return;
        }
        this.definedColor = Config.machineColor;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.saveAdditional(nbt, pRegistries);
        nbt.putInt("casingColor", this.definedColor);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            if (this.getLevel() != null && this.getLevel().isClientSide()) {
                this.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    public void scheduleRenderUpdate() {
        if (this.getLevel() != null) {
            if (this.getLevel().isClientSide()) {
                this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
            } else {
                this.getLevel().blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, 0);
            }
        }
    }
}

