/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import es.degrassi.mmreborn.common.block.prop.EnergyHatchSize;
import es.degrassi.mmreborn.common.entity.base.EnergyHatchEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyOutputHatchEntity
extends EnergyHatchEntity {
    public EnergyOutputHatchEntity(BlockPos pos, BlockState state) {
        super(EntityRegistration.ENERGY_OUTPUT_HATCH.get(), pos, state, EnergyHatchSize.TINY, IOType.OUTPUT);
    }

    public EnergyOutputHatchEntity(BlockPos pos, BlockState state, EnergyHatchSize size) {
        super(EntityRegistration.ENERGY_OUTPUT_HATCH.get(), pos, state, size, IOType.OUTPUT);
    }

    @Override
    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        long prevEnergy = this.energy;
        long transferCap = Math.min(this.size.transferLimit, this.energy);
        for (Direction face : Direction.values()) {
            if (transferCap > 0L) {
                int transferred = this.attemptFETransfer(face, this.convertDownEnergy(transferCap));
                transferCap -= (long)transferred;
                this.energy -= (long)transferred;
            }
            if (transferCap <= 0L) break;
        }
        if (prevEnergy != this.energy) {
            this.markForUpdate();
        }
    }

    private int attemptFETransfer(Direction face, int maxTransferLeft) {
        BlockCapabilityCache cache;
        IEnergyStorage ce;
        BlockPos at = this.getBlockPos().relative(face);
        int receivedEnergy = 0;
        BlockEntity te = this.level.getBlockEntity(at);
        if (te != null && !(te instanceof EnergyHatchEntity) && (ce = (IEnergyStorage)(cache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)this.getBlockPos().relative(face), (Object)face.getOpposite(), () -> !this.isRemoved(), () -> {})).getCapability()) != null && ce.canReceive()) {
            try {
                receivedEnergy = ce.receiveEnergy(maxTransferLeft, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return receivedEnergy;
    }
}

