/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity;

import es.degrassi.mmreborn.common.entity.base.BlockEntityRestrictedTick;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.machine.component.ChunkloadComponent;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.util.Chunkloader;
import es.degrassi.mmreborn.common.util.ChunkloaderList;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
public class ChunkloaderEntity
extends BlockEntityRestrictedTick
implements MachineComponentEntity<ChunkloadComponent> {
    private final Chunkloader chunkloader = new Chunkloader(this);
    private boolean unloaded = false;

    public ChunkloaderEntity(BlockPos pos, BlockState blockState) {
        super(EntityRegistration.CHUNKLOADER.get(), pos, blockState);
    }

    @Override
    public ChunkloadComponent provideComponent() {
        return new ChunkloadComponent(this);
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.saveAdditional(nbt, pRegistries);
        nbt.putString("chunkloader", this.chunkloader.toString());
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.chunkloader.deserializeNBT(pRegistries, nbt.getCompound("chunkloader"));
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        ChunkloaderList.add(this);
    }

    @Override
    public void doRestrictedTick() {
        this.chunkloader.serverTick();
    }

    public void onLoad() {
        super.onLoad();
        this.chunkloader.init();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void setRemoved() {
        this.chunkloader.onRemoved();
        super.setRemoved();
    }

    @Generated
    public Chunkloader getChunkloader() {
        return this.chunkloader;
    }

    @Generated
    public boolean isUnloaded() {
        return this.unloaded;
    }
}

