/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.jei;

import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedSizedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementItem;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiComponent;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.integration.jei.category.MMRRecipeCategory;
import es.degrassi.mmreborn.common.integration.jei.category.drawable.DrawableWrappedText;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class JeiItemComponent
extends JeiComponent<ItemStack, RecipeRequirement<ItemComponent, RequirementItem>> {
    public JeiItemComponent(RecipeRequirement<ItemComponent, RequirementItem> requirement) {
        super(requirement, 36, 0);
    }

    @Override
    public int getWidth() {
        return 18;
    }

    @Override
    public int getHeight() {
        return 18;
    }

    @Override
    public List<ItemStack> ingredients() {
        return Arrays.stream(((RequirementItem)this.requirement.requirement()).getIngredient().getItems()).map(ItemStack::copy).toList();
    }

    @Override
    public void setRecipe(MMRRecipeCategory category, IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        MutableComponent component = Component.empty();
        String chance = Utils.decimalFormat(this.requirement.chance() * 100.0f);
        if (this.requirement.chance() > 0.0f && this.requirement.chance() < 1.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance", (Object[])new Object[]{chance, "%"}).withColor(Config.chanceColor);
        } else if (this.requirement.chance() == 0.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance.nc").withColor(Config.chanceColor);
        }
        Font font = Minecraft.getInstance().font;
        recipe.chanceTexts.add((Pair<PositionedSizedRequirement, Object>)Pair.of((Object)new PositionedSizedRequirement(this.getPosition().x(), this.getPosition().y(), this.getWidth(), font.wordWrapHeight((FormattedText)component, this.getWidth())), (Object)new DrawableWrappedText(List.of(component), this.getWidth() + 2, true).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEX, this.getPosition().x()).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEY, this.getPosition().y()).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.SCALE, 0.75).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEZ, 500.0).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEX, (double)(this.getWidth() - 16) / 2.0).transform(DrawableWrappedText.Operation.ADD, DrawableWrappedText.State.TRANSLATEX, 17.0).transform(DrawableWrappedText.Operation.REMOVE, DrawableWrappedText.State.TRANSLATEX, Math.min(14, font.width((FormattedText)component))).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEY, (double)(this.getHeight() - 16) / 2.0).transform(DrawableWrappedText.Operation.MULTIPLY, DrawableWrappedText.State.TRANSLATEY, -1.0).transform(DrawableWrappedText.Operation.REMOVE, DrawableWrappedText.State.TRANSLATEY, 2.0)));
        ((IRecipeSlotBuilder)builder.addSlot(this.role(), this.getPosition().x(), this.getPosition().y()).addItemStacks(this.ingredients())).addRichTooltipCallback((view, tooltip) -> {
            if (this.requirement.chance() > 0.0f && this.requirement.chance() < 1.0f) {
                tooltip.add((FormattedText)Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + ((RequirementItem)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{chance, "%"}));
            } else if (this.requirement.chance() == 0.0f) {
                tooltip.add((FormattedText)Component.translatable((String)"modular_machinery_reborn.ingredient.chance.not_consumed"));
            } else if (this.requirement.chance() == 1.0f) {
                tooltip.add((FormattedText)Component.translatable((String)("modular_machinery_reborn.jei.ingredient.item." + ((RequirementItem)this.requirement.requirement()).getMode().name().toLowerCase(Locale.ROOT))));
            }
        }).setStandardSlotBackground();
    }
}

