/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.screen.EmiScreenManager;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.client.requirement.ChanceRendering;
import es.degrassi.mmreborn.client.requirement.ItemRendering;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementItem;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.IngredientHolder;
import es.degrassi.mmreborn.common.crafting.requirement.emi.SlotTooltip;
import es.degrassi.mmreborn.common.integration.emi.EmiIngredientRegistry;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class EmiItemComponent
extends EmiComponent<ItemStack, RecipeRequirement<ItemComponent, RequirementItem>>
implements SlotTooltip,
ItemRendering,
ChanceRendering,
IngredientHolder {
    private int item;
    private int width = 16;
    private int height = 16;
    @Nullable
    private EmiRecipe recipe;

    public EmiItemComponent(RecipeRequirement<ItemComponent, RequirementItem> requirement) {
        super(requirement, 36, 0);
    }

    @Override
    public void recipeContext(EmiRecipe recipe) {
        this.recipe = recipe;
    }

    @Override
    public EmiStack getStack() {
        return EmiStack.of((ItemStack)this.ingredients().get(this.item));
    }

    @Override
    public EmiIngredient getIngredient() {
        return EmiIngredientRegistry.getIngredient(this.requirement.getType()).create(this.requirement);
    }

    @Override
    public List<ItemStack> ingredients() {
        return this.getIngredient().getEmiStacks().stream().map(EmiStack::getItemStack).toList();
    }

    @Override
    public Bounds getBounds() {
        return super.getBounds();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.item = (int)(System.currentTimeMillis() / 1000L % (long)this.ingredients().size());
        this.width += 2;
        this.height += 2;
        super.render(guiGraphics, mouseX, mouseY);
        this.width -= 2;
        this.height -= 2;
        this.drawStack(guiGraphics, 1, 1, -1);
        this.drawChance(guiGraphics, true);
    }

    @Override
    public float getChance() {
        return this.requirement.chance();
    }

    @Override
    public IOType getActionType() {
        return ((RequirementItem)this.requirement.requirement()).getMode();
    }

    @Override
    public List<Component> getTooltip() {
        ArrayList list = Lists.newArrayList();
        this.addChanceTooltips(list);
        if (this.getStack().isEmpty()) {
            return list;
        }
        list.addAll(this.getStack().getTooltipText());
        return list;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.slotInteraction(bind -> bind.matchesMouse(button))) {
            return true;
        }
        return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)this.getStack(), this.getRecipe(), true), bind -> bind.matchesMouse(button));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.slotInteraction(bind -> bind.matchesKey(keyCode, scanCode))) {
            return true;
        }
        return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)this.getStack(), this.getRecipe(), true), bind -> bind.matchesKey(keyCode, scanCode));
    }

    @Override
    @Generated
    public int getWidth() {
        return this.width;
    }

    @Override
    @Generated
    public int getHeight() {
        return this.height;
    }

    @Override
    @Nullable
    @Generated
    public EmiRecipe getRecipe() {
        return this.recipe;
    }
}

