/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.FluidIngredient;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.NamedMapCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.integration.ingredient.HybridFluid;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.FluidComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import es.degrassi.mmreborn.common.util.HybridTank;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class RequirementFluid
implements IRequirement<FluidComponent> {
    public static final NamedMapCodec<RequirementFluid> CODEC = NamedCodec.record(instance -> instance.group(FluidIngredient.CODEC.fieldOf("fluid").forGetter(req -> req.ingredient), NamedCodec.enumCodec(IOType.class).fieldOf("mode").forGetter(IRequirement::getMode), NamedCodec.INT.optionalFieldOf("amount").forGetter(req -> Optional.of(req.amount)), PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, (fluid, mode, amount, position) -> new RequirementFluid((IOType)((Object)((Object)mode)), (FluidIngredient)fluid, amount.orElse(1000), (PositionedRequirement)position)), "FluidRequirement");
    private final PositionedRequirement position;
    private final IOType mode;
    public final HybridFluid required;
    public final int amount;
    private final FluidIngredient ingredient;

    public RequirementFluid(IOType ioType, FluidIngredient fluid, int amount, PositionedRequirement position) {
        this.ingredient = fluid;
        this.required = new HybridFluid(new FluidStack(fluid.getAll().getFirst(), amount));
        this.amount = amount;
        this.position = position;
        this.mode = ioType;
    }

    @Override
    public RequirementType<RequirementFluid> getType() {
        return RequirementTypeRegistration.FLUID.get();
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_FLUID.get();
    }

    @Override
    public boolean test(FluidComponent component, ICraftingContext context) {
        HybridTank handler = component.getContainerProvider();
        return switch (this.getMode()) {
            default -> throw new MatchException(null, null);
            case IOType.INPUT -> {
                int amount = (int)context.getIntegerModifiedValue(this.amount, this);
                FluidStack drained = handler.drain(this.required.asFluidStack().copyWithAmount(amount), IFluidHandler.FluidAction.SIMULATE);
                if (drained.getAmount() == this.required.getAmount()) {
                    yield true;
                }
                yield false;
            }
            case IOType.OUTPUT -> {
                int amount = (int)context.getIntegerModifiedValue(this.amount, this);
                int filled = handler.fill(this.required.asFluidStack().copyWithAmount(amount), IFluidHandler.FluidAction.SIMULATE);
                if (filled == amount) {
                    yield true;
                }
                yield false;
            }
            case IOType.NONE -> true;
        };
    }

    @Override
    public void gatherRequirements(IRequirementList<FluidComponent> list) {
        switch (this.getMode()) {
            case INPUT: {
                list.processOnStart(this::processInput);
                break;
            }
            case OUTPUT: {
                list.processOnEnd(this::processOutput);
            }
        }
    }

    private CraftingResult processInput(FluidComponent component, ICraftingContext context) {
        int amount;
        int toDrain = amount = (int)context.getIntegerModifiedValue(this.amount, this);
        FluidStack fluid = this.required.asFluidStack().copyWithAmount(toDrain);
        int canDrain = component.getContainerProvider().getFluidAmount();
        if (canDrain > 0) {
            canDrain = Math.min(canDrain, toDrain);
            component.getContainerProvider().drain(fluid.copyWithAmount(canDrain), IFluidHandler.FluidAction.EXECUTE);
            if ((toDrain -= canDrain) == 0) {
                return CraftingResult.success();
            }
        }
        return this.errorInput(amount, component.getContainerProvider().getFluid(), component.getContainerProvider().getFluidAmount());
    }

    private CraftingResult errorInput(int amount, FluidStack found, int amountFound) {
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.fluid.input", (Object[])new Object[]{amount, this.required.asFluidStack().getHoverName(), amountFound, found.getHoverName()}));
    }

    private CraftingResult errorOutput(FluidStack found) {
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.fluid.output.fluid", (Object[])new Object[]{this.required.asFluidStack().getHoverName(), found.getHoverName()}));
    }

    private CraftingResult errorOutput(int amount, int requiredSpace) {
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.fluid.output.space", (Object[])new Object[]{requiredSpace, amount}));
    }

    private CraftingResult processOutput(FluidComponent component, ICraftingContext context) {
        HybridTank handler = component.getContainerProvider();
        if (!handler.isEmpty() && !handler.getFluid().is(this.required.asFluidStack().getFluid())) {
            return this.errorOutput(handler.getFluid());
        }
        int amount = (int)context.getIntegerModifiedValue(this.amount, this);
        int canFill = handler.getSpace();
        if (canFill >= amount) {
            handler.fill(this.required.asFluidStack().copyWithAmount(amount), IFluidHandler.FluidAction.EXECUTE);
            return CraftingResult.success();
        }
        return this.errorOutput(canFill, amount);
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = IRequirement.super.asJson();
        json.addProperty("fluid", this.required.asFluidStack().getHoverName().getString());
        json.addProperty("amount", (Number)this.required.asFluidStack().getAmount());
        return json;
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)String.format("component.missing.fluid.%s", ioType.name().toLowerCase()));
    }

    @Override
    public boolean isComponentValid(FluidComponent m, ICraftingContext context) {
        if (this.getMode().isInput()) {
            if (m.getContainerProvider().isEmpty()) {
                return false;
            }
            return FluidStack.isSameFluidSameComponents((FluidStack)m.getContainerProvider().getFluid(), (FluidStack)this.required.asFluidStack());
        }
        if (m.getContainerProvider().isEmpty()) {
            return true;
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)m.getContainerProvider().getFluid(), (FluidStack)this.required.asFluidStack());
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }

    @Override
    @Generated
    public IOType getMode() {
        return this.mode;
    }
}

