/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.modifier;

import es.degrassi.mmreborn.common.crafting.modifier.IRecipeModifier;
import es.degrassi.mmreborn.common.crafting.modifier.RecipeModifier;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SpeedRecipeModifier
extends RecipeModifier {
    private final IRecipeModifier.OPERATION operation;

    public SpeedRecipeModifier(IRecipeModifier.OPERATION operation, float modifier, float chance, float max, float min) {
        super(RequirementTypeRegistration.SPEED.get(), IOType.INPUT, modifier, chance, max, min);
        this.operation = operation;
    }

    @Override
    public boolean shouldApply(RequirementType<?> type, IOType mode) {
        return type == this.requirementType && (double)this.chance > RAND.nextDouble();
    }

    @Override
    public float apply(float original) {
        float modified = switch (this.operation) {
            default -> throw new MatchException(null, null);
            case IRecipeModifier.OPERATION.ADDITION -> original + this.modifier;
            case IRecipeModifier.OPERATION.MULTIPLICATION -> original * this.modifier;
        };
        return Mth.clamp((float)modified, (float)this.min, (float)this.max);
    }

    @Override
    public Component getDefaultTooltip() {
        if (this.requirementType == RequirementTypeRegistration.SPEED.get() || this.requirementType == RequirementTypeRegistration.LOOT_TABLE.get()) {
            return Component.translatable((String)("mmr.recipe.modifier." + this.getTargetValue() + "." + String.valueOf((Object)this.getOperation())), (Object[])new Object[]{Float.valueOf(this.modifier)});
        }
        return Component.translatable((String)("mmr.recipe.modifier." + this.getTargetValue() + "." + String.valueOf((Object)this.getOperation())), (Object[])new Object[]{Float.valueOf(this.modifier), this.getMode().getSerializedName(), Float.valueOf(this.chance)});
    }

    @Override
    public IRecipeModifier.OPERATION getOperation() {
        return this.operation;
    }
}

