/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.helper;

import java.util.Locale;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingStatus {
    public static final CraftingStatus SUCCESS = new CraftingStatus(Type.CRAFTING, null);
    public static final CraftingStatus MISSING_STRUCTURE = new CraftingStatus(Type.MISSING_STRUCTURE, null);
    public static final CraftingStatus NO_RECIPE = new CraftingStatus(Type.NO_RECIPE, null);
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftingStatus> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CraftingStatus>(){

        public CraftingStatus decode(RegistryFriendlyByteBuf buffer) {
            Type type = (Type)buffer.readEnum(Type.class);
            MutableComponent message = null;
            if (buffer.readBoolean()) {
                message = Component.Serializer.fromJson((String)buffer.readUtf(), (HolderLookup.Provider)buffer.registryAccess());
            }
            return new CraftingStatus(type, (Component)message);
        }

        public void encode(RegistryFriendlyByteBuf buffer, CraftingStatus value) {
            buffer.writeEnum((Enum)value.status);
            buffer.writeBoolean(value.message != null);
            if (value.message != null) {
                buffer.writeUtf(Component.Serializer.toJson((Component)value.message, (HolderLookup.Provider)buffer.registryAccess()));
            }
        }
    };
    private final Type status;
    @Nullable
    private final Component message;

    private CraftingStatus(Type status, @Nullable Component unlocMessage) {
        this.status = status;
        this.message = unlocMessage;
    }

    public Component getUnlocMessage() {
        return this.message != null ? this.message : this.status.getUnlocalizedDescription();
    }

    public boolean isCrafting() {
        return this.status.isCrafting();
    }

    public boolean isFailure() {
        return this.status.isFailure();
    }

    public boolean isMissingStructure() {
        return this.status == Type.MISSING_STRUCTURE;
    }

    public static CraftingStatus working() {
        return SUCCESS;
    }

    public static CraftingStatus failure(Component message) {
        return new CraftingStatus(Type.FAILURE, message);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", this.status.getSerializedName());
        if (this.message != null) {
            tag.putString("message", Component.Serializer.toJson((Component)this.message, (HolderLookup.Provider)registries));
        }
        return tag;
    }

    public static CraftingStatus deserialize(CompoundTag tag, HolderLookup.Provider registries) {
        Type type = Type.fromString(tag.getString("type"));
        MutableComponent message = null;
        if (tag.contains("message")) {
            message = Component.Serializer.fromJson((String)tag.getString("message"), (HolderLookup.Provider)registries);
        }
        return new CraftingStatus(type, (Component)message);
    }

    public static CraftingStatus of(Type type, Component message) {
        return new CraftingStatus(type, message);
    }

    public static CraftingStatus of(String type, Component message) {
        return new CraftingStatus(Type.fromString(type), message);
    }

    @Generated
    public Type getStatus() {
        return this.status;
    }

    public static enum Type implements StringRepresentable
    {
        MISSING_STRUCTURE,
        NO_RECIPE,
        FAILURE,
        CRAFTING;


        public static Type fromString(String value) {
            return switch (value.toLowerCase(Locale.ROOT)) {
                case "missing_structure" -> MISSING_STRUCTURE;
                case "crafting" -> CRAFTING;
                case "failure" -> FAILURE;
                default -> NO_RECIPE;
            };
        }

        public boolean isCrafting() {
            return this == CRAFTING;
        }

        public boolean isFailure() {
            return this == FAILURE;
        }

        public Component getUnlocalizedDescription() {
            return Component.translatable((String)("gui.controller.status." + this.getSerializedName()));
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

