/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.common.block.BlockDynamicColor;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.entity.base.BlockEntitySynchronized;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.TileInventory;
import es.degrassi.mmreborn.common.util.IOInventory;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockMachineComponent
extends Block
implements BlockDynamicColor,
EntityBlock {
    public BlockMachineComponent(BlockBehaviour.Properties properties) {
        super(properties.requiresCorrectToolForDrops());
    }

    @Override
    public int getColorMultiplier(BlockState state, @Nullable BlockAndTintGetter worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (worldIn == null || pos == null) {
            return Config.machineColor;
        }
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof ColorableMachineEntity) {
            return ((ColorableMachineEntity)te).getMachineColor();
        }
        return Config.machineColor;
    }

    protected boolean triggerEvent(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, int pId, int pParam) {
        super.triggerEvent(pState, pLevel, pPos, pId, pParam);
        BlockEntity be = pLevel.getBlockEntity(pPos);
        return be != null && be.triggerEvent(pId, pParam);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ColorableMachineComponentEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return (level, pos, state, blockEntity) -> {
            if (blockEntity.getType() == pBlockEntityType && blockEntity instanceof BlockEntitySynchronized) {
                BlockEntitySynchronized entity = (BlockEntitySynchronized)blockEntity;
                entity.tick();
            }
        };
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        Object object = builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof TileInventory) {
            TileInventory entity = (TileInventory)object;
            IOInventory inv = entity.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                drops.add(stack);
            }
        }
        return drops;
    }

    protected boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }
}

