/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.client.container.FluidHatchContainer;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.block.prop.FluidHatchSize;
import es.degrassi.mmreborn.common.entity.base.FluidTankEntity;
import es.degrassi.mmreborn.common.util.HybridTank;
import es.degrassi.mmreborn.common.util.RedstoneHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class BlockFluidHatch
extends BlockMachineComponent {
    protected final FluidHatchSize size;

    public BlockFluidHatch(FluidHatchSize size) {
        super(BlockBehaviour.Properties.of().dynamicShape().noOcclusion().strength(2.0f, 10.0f).sound(SoundType.METAL));
        this.size = size;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.fluidhatch.tank.info", (Object[])new Object[]{this.size.getSize()}).withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof FluidTankEntity) {
            FluidTankEntity fluidTank = (FluidTankEntity)te;
            if (!stack.isEmpty() && FluidUtil.getFluidHandler((ItemStack)stack).isPresent()) {
                HybridTank ft = fluidTank.getTank();
                FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)ft);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                FluidHatchContainer.open(serverPlayer, fluidTank);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return RedstoneHelper.getRedstoneLevel(pLevel.getBlockEntity(pPos));
    }
}

