/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.item.CasingItem;
import es.degrassi.mmreborn.common.registration.BlockRegistration;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockCasing
extends BlockMachineComponent {
    public BlockCasing() {
        super(BlockBehaviour.Properties.of().strength(2.0f, 10.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().dynamicShape().noOcclusion());
    }

    @Override
    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List<ItemStack> drops = super.getDrops(state, builder);
        if (this == BlockRegistration.CASING_PLAIN.get()) {
            drops.add(((CasingItem)ItemRegistration.CASING_PLAIN.get()).getDefaultInstance());
        }
        if (this == BlockRegistration.CASING_VENT.get()) {
            drops.add(((CasingItem)ItemRegistration.CASING_VENT.get()).getDefaultInstance());
        }
        if (this == BlockRegistration.CASING_FIREBOX.get()) {
            drops.add(((CasingItem)ItemRegistration.CASING_FIREBOX.get()).getDefaultInstance());
        }
        if (this == BlockRegistration.CASING_GEARBOX.get()) {
            drops.add(((CasingItem)ItemRegistration.CASING_GEARBOX.get()).getDefaultInstance());
        }
        if (this == BlockRegistration.CASING_REINFORCED.get()) {
            drops.add(((CasingItem)ItemRegistration.CASING_REINFORCED.get()).getDefaultInstance());
        }
        if (this == BlockRegistration.CASING_CIRCUITRY.get()) {
            drops.add(((CasingItem)ItemRegistration.CASING_CIRCUITRY.get()).getDefaultInstance());
        }
        return drops;
    }

    public static enum CasingType implements StringRepresentable
    {
        PLAIN,
        VENT,
        FIREBOX,
        GEARBOX,
        REINFORCED,
        CIRCUITRY;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        public static CasingType value(String name) {
            return switch (name.toLowerCase(Locale.ROOT)) {
                case "vent" -> VENT;
                case "firebox" -> FIREBOX;
                case "gearbox" -> GEARBOX;
                case "reinforced" -> REINFORCED;
                case "circuitry" -> CIRCUITRY;
                default -> PLAIN;
            };
        }
    }
}

