/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.container;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.api.network.IData;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.IntegerSyncable;
import es.degrassi.mmreborn.api.network.syncable.ItemStackSyncable;
import es.degrassi.mmreborn.client.container.SlotItemComponent;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.network.server.SUpdateContainerPacket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerBase<T extends ColorableMachineComponentEntity>
extends AbstractContainerMenu {
    protected final Player player;
    protected final T entity;
    protected final List<ISyncable<?, ?>> stuffToSync = Lists.newArrayList();
    protected final List<SlotItemComponent> inputSlotComponents = new ArrayList<SlotItemComponent>();
    protected int firstComponentSlotIndex = 0;

    protected ContainerBase(T entity, Player player, @Nullable MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
        this.player = player;
        this.entity = entity;
        this.init();
    }

    public void init() {
        this.stuffToSync.clear();
        this.stuffToSync.add(ItemStackSyncable.create(() -> ((ContainerBase)this).getCarried(), arg_0 -> ((ContainerBase)this).setCarried(arg_0)));
        T t = this.entity;
        if (t instanceof ISyncableStuff) {
            ISyncableStuff syncableStuff = (ISyncableStuff)t;
            syncableStuff.getStuffToSync(this.stuffToSync::add);
        }
        this.slots.clear();
        this.inputSlotComponents.clear();
        AtomicInteger slotIndex = new AtomicInteger(0);
        this.addPlayerSlots(slotIndex);
        this.firstComponentSlotIndex = slotIndex.get() + 1;
    }

    protected Slot addSlot(Slot slot) {
        if ((slot = super.addSlot(slot)) instanceof SlotItemComponent) {
            SlotItemComponent sic = (SlotItemComponent)slot;
            this.inputSlotComponents.add(sic);
        }
        return slot;
    }

    public boolean needFullSync() {
        return this.entity.getLevel() != null && this.entity.getLevel().getGameTime() % 100L == 0L;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        this.getEntity().setChanged();
        super.clicked(slotId, button, clickType, player);
    }

    public void broadcastChanges() {
        Player player;
        if (this.player != null && (player = this.player) instanceof ServerPlayer) {
            ArrayList toSync;
            ServerPlayer sp = (ServerPlayer)player;
            if (this.needFullSync()) {
                toSync = new ArrayList();
                for (short id = 0; id < this.stuffToSync.size(); id = (short)(id + 1)) {
                    toSync.add((IData<?>)this.stuffToSync.get(id).getData(id));
                }
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new SUpdateContainerPacket(this.containerId, toSync), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            toSync = new ArrayList();
            for (short id = 0; id < this.stuffToSync.size(); id = (short)((short)(id + 1))) {
                if (!this.stuffToSync.get(id).needSync()) continue;
                toSync.add((IData<?>)this.stuffToSync.get(id).getData(id));
            }
            if (!toSync.isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new SUpdateContainerPacket(this.containerId, toSync), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    protected DataSlot addDataSlot(DataSlot intReferenceHolder) {
        this.stuffToSync.add(IntegerSyncable.create(() -> ((DataSlot)intReferenceHolder).get(), arg_0 -> ((DataSlot)intReferenceHolder).set(arg_0)));
        return intReferenceHolder;
    }

    protected void addDataSlots(ContainerData array) {
        int i = 0;
        while (i < array.getCount()) {
            int index = i++;
            this.stuffToSync.add(IntegerSyncable.create(() -> array.get(index), integer -> array.set(index, integer.intValue())));
        }
    }

    public void handleData(IData<?> data) {
        short id = data.getID();
        ISyncable<?, ?> syncable = this.stuffToSync.get(id);
        if (syncable != null) {
            syncable.set(data.getValue());
        }
    }

    protected Slot addSyncedSlot(Slot slot) {
        this.stuffToSync.add(ItemStackSyncable.create(() -> ((Slot)slot).getItem(), arg_0 -> ((Slot)slot).set(arg_0)));
        return this.addSlot(slot);
    }

    protected void addPlayerSlots(AtomicInteger slotIndex) {
        int i;
        for (i = 0; i < 9; ++i) {
            this.addSyncedSlot(new Slot((Container)this.player.getInventory(), slotIndex.getAndIncrement(), 8 + i * 18, 142));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSyncedSlot(new Slot((Container)this.player.getInventory(), slotIndex.getAndIncrement(), 8 + j * 18, 84 + i * 18));
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.getItem().isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (slot.container == this.player.getInventory()) {
            SlotItemComponent slotComponent;
            ItemStack stack = slot.getItem().copy();
            List<SlotItemComponent> components = this.inputSlotComponents;
            Iterator<SlotItemComponent> iterator = components.iterator();
            while (iterator.hasNext() && !(stack = (slotComponent = iterator.next()).getComponent().insertItemBypassLimit(stack, false)).isEmpty()) {
            }
            if (stack.isEmpty()) {
                slot.remove(slot.getItem().getCount());
            } else {
                slot.remove(slot.getItem().getCount() - stack.getCount());
            }
        } else {
            if (!(slot instanceof SlotItemComponent)) {
                return ItemStack.EMPTY;
            }
            SlotItemComponent slotComponent = (SlotItemComponent)slot;
            ItemStack removed = slotComponent.getItem();
            if (!this.moveItemStackTo(removed, 0, this.firstComponentSlotIndex - 1, false)) {
                return ItemStack.EMPTY;
            }
            slotComponent.setChanged();
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return player.level().getBlockState(this.entity.getBlockPos()) == this.entity.getBlockState() && player.level().getBlockEntity(this.entity.getBlockPos()) == this.entity && player.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.entity.getBlockPos())) <= 64.0;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public T getEntity() {
        return this.entity;
    }

    @Generated
    public List<ISyncable<?, ?>> getStuffToSync() {
        return this.stuffToSync;
    }

    @Generated
    public List<SlotItemComponent> getInputSlotComponents() {
        return this.inputSlotComponents;
    }

    @Generated
    public int getFirstComponentSlotIndex() {
        return this.firstComponentSlotIndex;
    }
}

