/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.crafting.requirement;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.manager.ComponentManager;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class RecipeRequirement<C extends MachineComponent<?>, R extends IRequirement<C>> {
    public static final NamedCodec<RecipeRequirement<?, ?>> CODEC = NamedCodec.record(recipeRequirementInstance -> recipeRequirementInstance.group(IRequirement.CODEC.forGetter(RecipeRequirement::requirement), NamedCodec.floatRange(0.0f, 1.0f).optionalFieldOf("chance", Float.valueOf(1.0f)).forGetter(requirement -> Float.valueOf(requirement.chance))).apply((Applicative)recipeRequirementInstance, RecipeRequirement::new), "Recipe requirement");
    private final R requirement;
    private float chance;

    public RecipeRequirement(R requirement, float chance) {
        this.requirement = requirement;
        this.chance = chance;
    }

    public RecipeRequirement<C, R> castRequirement(RecipeRequirement<?, ?> requirement) {
        return requirement;
    }

    public RecipeRequirement(R requirement) {
        this(requirement, 1.0f);
    }

    public RequirementType<R> getType() {
        return this.requirement.getType();
    }

    public R requirement() {
        return this.requirement;
    }

    public float chance() {
        return this.chance;
    }

    public void setChance(float chance) {
        this.chance = Mth.clamp((float)chance, (float)0.0f, (float)1.0f);
    }

    public C findComponent(ComponentManager manager, ICraftingContext context) {
        return (C)((MachineComponent)manager.getComponent(this.requirement, context).orElse(null));
    }

    public CraftingResult test(ComponentManager manager, ICraftingContext context) {
        C component = this.findComponent(manager, context);
        if (component == null) {
            return CraftingResult.error((Component)Component.empty());
        }
        return this.requirement.test(component, context) ? CraftingResult.success() : CraftingResult.error((Component)Component.empty());
    }

    public boolean shouldSkip(Random rand, ICraftingContext context) {
        float chance = context.getModifiedValue(this.chance, (IRequirement<?>)this.requirement);
        return rand.nextFloat() > chance;
    }

    public boolean isModified() {
        return this.requirement().isModified();
    }

    public JsonObject asJson() {
        JsonObject json = this.requirement.asJson();
        json.addProperty("chance", (Number)Float.valueOf(this.chance));
        return json;
    }
}

