/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.crafting.requirement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.codec.NamedMapCodec;
import es.degrassi.mmreborn.api.codec.RegistrarCodec;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public interface IRequirement<C extends MachineComponent<?>> {
    public static final NamedMapCodec<IRequirement<?>> CODEC = RegistrarCodec.REQUIREMENT_NEW.dispatch(IRequirement::getType, RequirementType::getCodec, "Requirement");

    public RequirementType<? extends IRequirement<C>> getType();

    public ComponentType getComponentType();

    public IOType getMode();

    public boolean test(C var1, ICraftingContext var2);

    public void gatherRequirements(IRequirementList<C> var1);

    default public ResourceLocation getId() {
        return ModularMachineryReborn.getRequirementRegistrar().getKey(this.getType());
    }

    public PositionedRequirement getPosition();

    default public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("actionType", this.getMode().name());
        json.add("position", (JsonElement)this.getPosition().asJson());
        json.addProperty("type", this.getId() != null ? this.getId().toString() : "");
        json.addProperty("modified", Boolean.valueOf(this.isModified()));
        return json;
    }

    @Nonnull
    public Component getMissingComponentErrorMessage(IOType var1);

    public boolean isComponentValid(C var1, ICraftingContext var2);

    default public boolean isModified() {
        return false;
    }

    default public void setModified(boolean modified) {
    }
}

