/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import es.degrassi.mmreborn.api.IIngredient;
import es.degrassi.mmreborn.api.TagUtil;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.material.Fluid;

public class FluidTagIngredient
implements IIngredient<Fluid> {
    private static final NamedCodec<FluidTagIngredient> CODEC_FOR_DATAPACK = NamedCodec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)FluidTagIngredient.create(string));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(e::getMessage);
        }
    }, FluidTagIngredient::toString, "Fluid tag ingredient");
    private static final NamedCodec<FluidTagIngredient> CODEC_FOR_KUBEJS = DefaultCodecs.tagKey(Registries.FLUID).fieldOf("tag").xmap(FluidTagIngredient::new, ingredient -> ingredient.tag, "Fluid tag ingredient");
    public static final NamedCodec<FluidTagIngredient> CODEC = NamedCodec.either(CODEC_FOR_DATAPACK, CODEC_FOR_KUBEJS, "Fluid Tag Ingredient").xmap(either -> (FluidTagIngredient)either.map(Function.identity(), Function.identity()), Either::left, "Fluid tag ingredient");
    private final TagKey<Fluid> tag;

    private FluidTagIngredient(TagKey<Fluid> tag) {
        this.tag = tag;
    }

    public static FluidTagIngredient create(String s) throws IllegalArgumentException {
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        if (Utils.isResourceNameValid(s)) {
            throw new IllegalArgumentException(String.format("Invalid tag id : %s", s));
        }
        TagKey tag = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.parse((String)s));
        return new FluidTagIngredient((TagKey<Fluid>)tag);
    }

    public static FluidTagIngredient create(TagKey<Fluid> tag) throws IllegalArgumentException {
        return new FluidTagIngredient(tag);
    }

    @Override
    public List<Fluid> getAll() {
        return TagUtil.getFluids(this.tag).toList();
    }

    @Override
    public IIngredient<Fluid> copy() {
        return new FluidTagIngredient(this.tag);
    }

    @Override
    public IIngredient<Fluid> copyWithRotation(Rotation rotation) {
        return new FluidTagIngredient(this.tag);
    }

    @Override
    public JsonObject asJson() {
        return new JsonObject();
    }

    @Override
    public boolean test(Fluid fluid) {
        return this.getAll().contains(fluid);
    }

    public String toString() {
        return "#" + String.valueOf(this.tag.location());
    }
}

