/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledDistributorModule;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BeamData;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class CompiledEnergyDistributorModule
extends CompiledModule {
    protected final CompiledDistributorModule.DistributorSettings settings;

    public CompiledEnergyDistributorModule(@Nullable ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        this.settings = (CompiledDistributorModule.DistributorSettings)stack.getOrDefault(ModDataComponents.DISTRIBUTOR_SETTINGS, (Object)CompiledDistributorModule.DistributorSettings.DEFAULT);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        IEnergyStorage storage;
        if (!this.getTargets().isEmpty() && (storage = router.getEnergyStorage()) != null) {
            boolean doBeam;
            boolean bl = doBeam = router.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get()) < 2;
            return this.settings.isPulling() ? this.pullEnergy(router, storage, this.getTargets(), doBeam) > 0 : this.sendEnergy(router, storage, this.getTargets(), doBeam) > 0;
        }
        return false;
    }

    private int sendEnergy(@Nonnull ModularRouterBlockEntity router, IEnergyStorage storage, List<ModuleTarget> targets, boolean doBeam) {
        int total = 0;
        int toSend = storage.getEnergyStored() / targets.size();
        for (ModuleTarget target : targets) {
            total += target.getEnergyHandler().map(handler -> {
                int toExtract = storage.extractEnergy(toSend, true);
                int sent = handler.receiveEnergy(toExtract, false);
                storage.extractEnergy(sent, false);
                if (sent > 0 && doBeam) {
                    router.addItemBeam(new BeamData.Builder(router, target.gPos.pos(), -520142784).build());
                }
                return sent;
            }).orElse(0).intValue();
        }
        return total;
    }

    private int pullEnergy(@Nonnull ModularRouterBlockEntity router, IEnergyStorage storage, List<ModuleTarget> targets, boolean doBeam) {
        int total = 0;
        int toPull = (storage.getMaxEnergyStored() - storage.getEnergyStored()) / targets.size();
        for (ModuleTarget target : targets) {
            total += target.getEnergyHandler().map(handler -> {
                int toExtract = handler.extractEnergy(toPull, true);
                int received = storage.receiveEnergy(toExtract, false);
                handler.extractEnergy(received, false);
                if (received > 0 && doBeam) {
                    router.addItemBeam(new BeamData.Builder(router, target.gPos.pos(), -524271456).reversed(true).build());
                }
                return received;
            }).orElse(0).intValue();
        }
        return total;
    }

    public boolean isPulling() {
        return this.settings.isPulling();
    }
}

