/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.modularrouters.api.event.AddModuleTargetEvent;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.ModuleTargetList;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;

public interface ITargetedModule {
    @ApiStatus.OverrideOnly
    default public boolean isValidTarget(UseOnContext ctx) {
        return InventoryUtils.getInventory(ctx.getLevel(), ctx.getClickedPos(), ctx.getClickedFace()).isPresent();
    }

    default public int getMaxTargets() {
        return 1;
    }

    default public boolean isRangeLimited() {
        return true;
    }

    default public boolean canOperateInDimension(ResourceKey<Level> dimension) {
        return true;
    }

    public static Set<ModuleTarget> getTargets(ItemStack stack, boolean checkBlockName) {
        int max = ((ITargetedModule)stack.getItem()).getMaxTargets();
        HashSet result = Sets.newHashSet();
        boolean update = false;
        List<ModuleTarget> targets = ((ModuleTargetList)stack.getOrDefault(ModDataComponents.MODULE_TARGET_LIST, (Object)ModuleTargetList.EMPTY)).targets();
        for (int i = 0; i < targets.size() && result.size() < max; ++i) {
            ModuleTarget target = targets.get(i);
            if (checkBlockName) {
                ModuleTarget newTarget = ITargetedModule.updateTargetBlockName(target);
                if (newTarget != target) {
                    update = true;
                }
                target = newTarget;
            }
            if (target == null) continue;
            result.add(target);
        }
        if (update) {
            ITargetedModule.setTargets(stack, result);
        }
        return result;
    }

    public static void setTargets(ItemStack stack, Collection<ModuleTarget> targets) {
        stack.set(ModDataComponents.MODULE_TARGET_LIST, (Object)new ModuleTargetList(List.copyOf(targets)));
    }

    public static boolean canSelectTarget(UseOnContext context) {
        Item module = context.getItemInHand().getItem();
        return ((AddModuleTargetEvent)NeoForge.EVENT_BUS.post((Event)new AddModuleTargetEvent((ModuleItem)module, context, ((ITargetedModule)module).isValidTarget(context)))).isValid();
    }

    private static ModuleTarget updateTargetBlockName(ModuleTarget target) {
        ServerLevel level = MiscUtil.getWorldForGlobalPos(target.gPos);
        BlockPos pos = target.gPos.pos();
        if (level != null && level.getChunkSource().hasChunk(pos.getX() >> 4, pos.getZ() >> 4)) {
            String invName = BlockUtil.getBlockName((Level)level, pos);
            if (!target.blockTranslationKey.equals(invName)) {
                return new ModuleTarget(target.gPos, target.face, invName);
            }
            return target;
        }
        return null;
    }
}

