/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;

public class AugmentHandler
extends ItemStackHandler {
    private final ItemStack holderStack;
    private final ModularRouterBlockEntity router;

    public AugmentHandler(ItemStack holderStack, ModularRouterBlockEntity router) {
        super(4);
        this.router = router;
        Validate.isTrue((boolean)(holderStack.getItem() instanceof ModuleItem), (String)"holder stack must be a module!", (Object[])new Object[0]);
        this.holderStack = holderStack;
        List augmentStacks = ((ItemContainerContents)holderStack.getOrDefault(ModDataComponents.AUGMENTS, (Object)ItemContainerContents.EMPTY)).stream().limit(4L).toList();
        for (int i = 0; i < 4 && i < augmentStacks.size(); ++i) {
            if (!(((ItemStack)augmentStacks.get(i)).getItem() instanceof AugmentItem)) continue;
            this.setStackInSlot(i, (ItemStack)augmentStacks.get(i));
        }
    }

    public ItemStack getHolderStack() {
        return this.holderStack;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof AugmentItem)) {
            return false;
        }
        AugmentItem augment = (AugmentItem)item;
        if (augment.getMaxAugments((ModuleItem)this.holderStack.getItem()) == 0) {
            return false;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            if (slot == i || stack.getItem() != this.getStackInSlot(i).getItem()) continue;
            return false;
        }
        return true;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        int n;
        Item item = stack.getItem();
        if (item instanceof AugmentItem) {
            AugmentItem augment = (AugmentItem)item;
            n = augment.getMaxAugments((ModuleItem)this.holderStack.getItem());
        } else {
            n = 0;
        }
        return n;
    }

    protected void onContentsChanged(int slot) {
        this.save();
    }

    private void save() {
        this.holderStack.set(ModDataComponents.AUGMENTS, (Object)ItemContainerContents.fromItems((List)this.stacks));
        if (this.router != null) {
            this.router.recompileNeeded(ModularRouterBlockEntity.RecompileFlag.MODULES);
        }
    }
}

