/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.AbstractMRContainerMenu;
import me.desht.modularrouters.container.FilterSlot;
import me.desht.modularrouters.container.handler.AugmentHandler;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ModuleMenu
extends AbstractMRContainerMenu {
    public static final int AUGMENT_START = 9;
    private static final int INV_START = 13;
    private static final int INV_END = 39;
    private static final int HOTBAR_START = 40;
    private static final int HOTBAR_END = 48;
    private static final int PLAYER_INV_Y = 116;
    private static final int PLAYER_INV_X = 16;
    private static final int PLAYER_HOTBAR_Y = 174;
    private final BaseModuleHandler.ModuleFilterHandler filterHandler;
    private final AugmentHandler augmentHandler;
    private final int currentSlot;
    protected final ModularRouterBlockEntity router;
    private final MFLocator locator;

    public ModuleMenu(int windowId, Inventory inv, FriendlyByteBuf extra) {
        this(ModMenuTypes.BASE_MODULE_MENU.get(), windowId, inv, (MFLocator)MFLocator.STREAM_CODEC.decode((Object)extra));
    }

    public ModuleMenu(MenuType type, int windowId, Inventory inv, FriendlyByteBuf extra) {
        this(type, windowId, inv, (MFLocator)MFLocator.STREAM_CODEC.decode((Object)extra));
    }

    public ModuleMenu(MenuType type, int windowId, Inventory inv, MFLocator locator) {
        super(type, windowId);
        int i;
        this.locator = locator;
        this.router = locator.getRouter(inv.player.level()).orElse(null);
        assert (this.router != null || locator.hand() != null);
        ItemStack moduleStack = locator.getModuleStack(inv.player);
        this.filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack, this.router);
        this.augmentHandler = new AugmentHandler(moduleStack, this.router);
        this.currentSlot = inv.selected + 40;
        for (i = 0; i < 9; ++i) {
            this.addSlot((Slot)new FilterSlot((IItemHandler)this.filterHandler, i, 8 + 18 * (i % 3), 17 + 18 * (i / 3)));
        }
        for (i = 0; i < 4; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.augmentHandler, i, 78 + 18 * (i % 2), 75 + 18 * (i / 2)));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 16 + j * 18, 116 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 16 + i * 18, 174));
        }
    }

    public MFLocator getLocator() {
        return this.locator;
    }

    public ModularRouterBlockEntity getRouter() {
        return this.router;
    }

    protected void transferStackInExtraSlot(Player player, int index) {
    }

    protected void slotClickExtraSlot(int slot, int dragType, ClickType clickTypeIn, Player player) {
    }

    public boolean stillValid(Player playerIn) {
        return this.router == null || !this.router.isRemoved();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot srcSlot = (Slot)this.slots.get(index);
        if (srcSlot.hasItem()) {
            if (index < 9) {
                srcSlot.set(ItemStack.EMPTY);
            } else if (index < 13) {
                ItemStack stackInSlot = srcSlot.getItem();
                if (!this.moveItemStackTo(stackInSlot, 13, 49, false)) {
                    return ItemStack.EMPTY;
                }
                srcSlot.set(stackInSlot);
                this.broadcastChanges();
            } else if (index <= 48) {
                ItemStack stackInSlot = srcSlot.getItem();
                if (stackInSlot.getItem() instanceof AugmentItem && this.augmentHandler.getHolderStack().getCount() == 1) {
                    if (!this.moveItemStackTo(stackInSlot, 9, 13, false)) {
                        return ItemStack.EMPTY;
                    }
                    this.broadcastChanges();
                } else {
                    ItemStack stack = stackInSlot.copy();
                    stack.setCount(1);
                    int firstFree = -1;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack0 = this.filterHandler.getStackInSlot(i);
                        if (ItemStack.isSameItem((ItemStack)stack0, (ItemStack)stack)) {
                            firstFree = i;
                            break;
                        }
                        if (firstFree >= 0 || !stack0.isEmpty() || !this.filterHandler.isItemValid(i, stack)) continue;
                        firstFree = i;
                    }
                    if (firstFree >= 0) {
                        ((Slot)this.slots.get(firstFree)).set(stack);
                        srcSlot.set(stackInSlot);
                    }
                }
            } else {
                this.transferStackInExtraSlot(player, index);
            }
        }
        return ItemStack.EMPTY;
    }

    public void clicked(int slot, int dragType, ClickType clickTypeIn, Player player) {
        boolean forceUpdate = false;
        if (slot > 48) {
            this.slotClickExtraSlot(slot, dragType, clickTypeIn, player);
            return;
        }
        if (slot >= 9 && slot < 13 && this.augmentHandler.getHolderStack().getCount() > 1) {
            return;
        }
        switch (clickTypeIn) {
            case PICKUP: {
                if (this.router == null && slot == this.currentSlot) {
                    return;
                }
                if (slot >= 0 && slot < 9) {
                    Slot s = (Slot)this.slots.get(slot);
                    ItemStack stackOnCursor = this.getCarried();
                    if (stackOnCursor.isEmpty() || this.isItemOKForFilter(stackOnCursor, slot)) {
                        s.set(stackOnCursor.isEmpty() ? ItemStack.EMPTY : stackOnCursor.copyWithCount(1));
                    }
                    return;
                }
                if (slot >= 9 && slot < 13 && this.augmentHandler.getHolderStack().getCount() == 1) {
                    forceUpdate = true;
                }
            }
            case THROW: {
                if (slot >= 0 && slot < 9) {
                    return;
                }
                if (slot < 9 || slot >= 13 || this.augmentHandler.getHolderStack().getCount() != 1) break;
                forceUpdate = true;
            }
        }
        super.clicked(slot, dragType, clickTypeIn, player);
        if (forceUpdate) {
            ((Slot)this.slots.get(slot)).set(((Slot)this.slots.get(slot)).getItem());
            this.broadcastChanges();
        }
    }

    private boolean isItemOKForFilter(ItemStack stack, int slot) {
        if (this.filterHandler.isItemValid(slot, stack)) {
            for (int i = 0; i < this.filterHandler.getSlots(); ++i) {
                if (this.filterHandler.getStackInSlot(i).getItem() != stack.getItem() || stack.getItem() instanceof SmartFilterItem) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canDragTo(Slot p_94531_1_) {
        return false;
    }
}

