/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.textfield;

import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidgetMR;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;

public class FloatTextField
extends TextFieldWidgetMR {
    private final float min;
    private final float max;
    private float incr = 1.0f;
    private float fine = 0.1f;
    private float coarse = 5.0f;
    private String precStr = "%.1f";

    public FloatTextField(Font fontrendererObj, int x, int y, int par5Width, int par6Height, float min, float max) {
        super(fontrendererObj, x, y, par5Width, par6Height);
        this.min = min;
        this.max = max;
        this.setMaxLength(5);
        this.setFilter(input -> {
            if (input == null || input.isEmpty() || input.equals("-")) {
                return true;
            }
            try {
                float f = Float.parseFloat(input);
                return f >= this.min && f <= this.max;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    public void setIncr(float incr, float fine, float coarse) {
        this.incr = incr;
        this.fine = fine;
        this.coarse = coarse;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return switch (keyCode) {
            case 265 -> this.adjustField(this.incr);
            case 264 -> this.adjustField(-this.incr);
            case 266 -> this.adjustField(this.max);
            case 267 -> this.adjustField(-this.max);
            default -> super.keyPressed(keyCode, scanCode, modifiers);
        };
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        this.adjustField(pMouseY > 0.0 ? this.incr : -this.incr);
        return true;
    }

    public void setValue(float newVal) {
        if (newVal >= this.min && newVal <= this.max) {
            this.setValue(String.format(this.precStr, Float.valueOf(newVal)));
        }
    }

    public void setPrecision(int precision) {
        this.precStr = "%." + precision + "f";
    }

    private boolean adjustField(float adj) {
        float val;
        if (Screen.hasControlDown()) {
            adj *= this.fine;
        } else if (Screen.hasShiftDown()) {
            adj *= this.coarse;
        }
        try {
            val = Float.parseFloat(this.getValue());
        }
        catch (NumberFormatException e) {
            val = this.min;
        }
        float newVal = Math.max(this.min, Math.min(this.max, val + adj));
        if (newVal != val) {
            this.setValue("");
            this.insertText(String.format(this.precStr, Float.valueOf(newVal)));
        }
        return true;
    }

    public float getFloatValue() {
        try {
            return Float.parseFloat(this.getValue());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }
}

