/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui;

import java.util.List;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.widgets.EnergyWidget;
import me.desht.modularrouters.client.gui.widgets.button.RedstoneBehaviourButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.RouterMenu;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.settings.RedstoneBehaviour;
import me.desht.modularrouters.network.messages.OpenGuiMessage;
import me.desht.modularrouters.network.messages.RouterSettingsMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.network.PacketDistributor;

public class ModularRouterScreen
extends AbstractContainerScreen<RouterMenu>
implements ISendToServer,
MenuAccess<RouterMenu> {
    private static final ResourceLocation TEXTURE_LOCATION = MiscUtil.RL("textures/gui/router.png");
    private static final int LABEL_YPOS = 5;
    private static final int MODULE_LABEL_YPOS = 60;
    private static final int BUFFER_LABEL_YPOS = 28;
    private static final int UPGRADES_LABEL_YPOS = 28;
    private static final int GUI_HEIGHT = 186;
    private static final int GUI_WIDTH = 176;
    private static final int BUTTON_HEIGHT = 16;
    private static final int BUTTON_WIDTH = 16;
    private static final int MODULE_START = 37;
    private static final int MODULE_END = 45;
    private RedstoneBehaviourButton redstoneBehaviourButton;
    private EcoButton ecoButton;
    private EnergyDirectionButton energyDirButton;
    private EnergyWidget energyWidget;
    private EnergyWarningButton energyWarning;
    private int energyUsage;

    public ModularRouterScreen(RouterMenu container, Inventory inventoryPlayer, Component displayName) {
        super((AbstractContainerMenu)container, inventoryPlayer, displayName);
        this.imageWidth = 176;
        this.imageHeight = 186;
    }

    public void init() {
        super.init();
        ModularRouterBlockEntity router = ((RouterMenu)this.menu).getRouter();
        this.redstoneBehaviourButton = new RedstoneBehaviourButton(this.leftPos + 152, this.topPos + 10, 16, 16, router.getRedstoneBehaviour(), (ISendToServer)this);
        this.addRenderableWidget((GuiEventListener)this.redstoneBehaviourButton);
        this.ecoButton = new EcoButton(this, this.leftPos + 132, this.topPos + 10, 16, 16, router.getEcoMode());
        this.addRenderableWidget((GuiEventListener)this.ecoButton);
        this.energyDirButton = new EnergyDirectionButton(this, this.leftPos - 8, this.topPos + 40, router.getEnergyDirection());
        this.addRenderableWidget((GuiEventListener)this.energyDirButton);
        this.energyWidget = new EnergyWidget(this.leftPos - 22, this.topPos + 15, router.getEnergyStorage());
        this.addRenderableWidget((GuiEventListener)this.energyWidget);
        this.energyWarning = new EnergyWarningButton(this.leftPos + 4, this.topPos + 4);
        this.addRenderableWidget((GuiEventListener)this.energyWarning);
        this.energyDirButton.visible = router.getEnergyCapacity() > 0;
        this.energyWidget.visible = this.energyDirButton.visible;
        this.energyWarning.visible = false;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent title = ClientUtil.xlate("block.modularrouters.modular_router", new Object[0]);
        graphics.drawString(this.font, (Component)title, this.imageWidth / 2 - this.font.width((FormattedText)title) / 2, 5, -12566464, false);
        graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.label.buffer", new Object[0]), 8, 28, -12566464, false);
        graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.label.upgrades", new Object[0]), 80, 28, -12566464, false);
        graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.label.modules", new Object[0]), 8, 60, -12566464, false);
        graphics.drawString(this.font, (Component)ClientUtil.xlate("container.inventory", new Object[0]), 8, this.imageHeight - 96 + 4, -12566464, false);
    }

    protected void renderBg(GuiGraphics graphics, float v, int i, int i1) {
        graphics.blit(TEXTURE_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (((RouterMenu)this.menu).getRouter().getEnergyCapacity() > 0) {
            graphics.blit(TEXTURE_LOCATION, this.leftPos - 27, this.topPos, 180, 0, 32, 100);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return ClientSetup.keybindConfigure.getKey().getValue() == keyCode ? this.handleModuleConfig() : super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double x, double y, int btn) {
        return btn == 2 ? this.handleModuleConfig() : super.mouseClicked(x, y, btn);
    }

    public void containerTick() {
        boolean hasEnergyUpgrade;
        super.containerTick();
        this.energyUsage = 0;
        for (int i = 37; i < 45; ++i) {
            ItemStack stack = ((RouterMenu)this.menu).getSlot(i).getItem();
            Item item = stack.getItem();
            if (!(item instanceof ModuleItem)) continue;
            ModuleItem moduleItem = (ModuleItem)item;
            this.energyUsage += moduleItem.getEnergyCost(stack);
        }
        this.energyWidget.visible = hasEnergyUpgrade = ((RouterMenu)this.menu).getRouter().getEnergyCapacity() > 0;
        this.energyDirButton.visible = hasEnergyUpgrade && ((RouterMenu)this.getMenu()).getSlot(36).getItem().getCapability(Capabilities.EnergyStorage.ITEM) != null;
        this.energyWarning.setX(hasEnergyUpgrade ? this.leftPos - 22 : this.leftPos + 4);
        this.energyWarning.tick();
    }

    private boolean handleModuleConfig() {
        Slot slot = this.getSlotUnderMouse();
        if (slot == null || !(slot.getItem().getItem() instanceof ModuleItem) || slot.index < 37 || slot.index > 45) {
            return false;
        }
        MFLocator locator = MFLocator.moduleInRouter(((RouterMenu)this.menu).getRouter().getBlockPos(), slot.index - 37);
        PacketDistributor.sendToServer((CustomPacketPayload)OpenGuiMessage.openModuleInRouter(locator), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    @Override
    public void sendToServer() {
        ModularRouterBlockEntity router = ((RouterMenu)this.menu).getRouter();
        router.setRedstoneBehaviour((RedstoneBehaviour)this.redstoneBehaviourButton.getState());
        router.setEcoMode(this.ecoButton.isToggled());
        router.setEnergyDirection((ModularRouterBlockEntity.EnergyDirection)this.energyDirButton.getState());
        PacketDistributor.sendToServer((CustomPacketPayload)RouterSettingsMessage.forRouter(router), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public List<Rect2i> getExtraArea() {
        return ((RouterMenu)this.menu).getRouter().getEnergyCapacity() > 0 ? List.of(new Rect2i(this.leftPos - 27, this.topPos, 32, 100)) : List.of();
    }

    private class EcoButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(80, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(96, 16);

        EcoButton(ModularRouterScreen modularRouterScreen, int x, int y, int width, int height, boolean initialVal) {
            super(x, y, width, height, initialVal, modularRouterScreen);
            this.setTooltips((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.eco.false", new Object[0]), (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.eco.true", Float.valueOf((float)((Integer)ConfigHolder.common.router.ecoTimeout.get()).intValue() / 20.0f), Float.valueOf((float)((Integer)ConfigHolder.common.router.lowPowerTickRate.get()).intValue() / 20.0f)));
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }

    private class EnergyDirectionButton
    extends TexturedCyclerButton<ModularRouterBlockEntity.EnergyDirection> {
        public EnergyDirectionButton(ModularRouterScreen modularRouterScreen, int x, int y, ModularRouterBlockEntity.EnergyDirection initialVal) {
            super(x, y, 14, 14, initialVal, modularRouterScreen);
        }

        @Override
        protected XYPoint getTextureXY() {
            int x = switch ((ModularRouterBlockEntity.EnergyDirection)this.getState()) {
                default -> throw new MatchException(null, null);
                case ModularRouterBlockEntity.EnergyDirection.TO_ROUTER -> 224;
                case ModularRouterBlockEntity.EnergyDirection.FROM_ROUTER -> 144;
                case ModularRouterBlockEntity.EnergyDirection.NONE -> 176;
            };
            return new XYPoint(x, 0);
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }
    }

    private class EnergyWarningButton
    extends TexturedButton {
        private EnergyStatus prevStatus;

        public EnergyWarningButton(int x, int y) {
            super(x, y, 16, 16, b -> {});
        }

        private void tick() {
            EnergyStatus status = ModularRouterScreen.this.energyUsage <= ((RouterMenu)ModularRouterScreen.this.menu).getRouter().getEnergyStorage().getEnergyStored() ? EnergyStatus.OK : (((RouterMenu)ModularRouterScreen.this.menu).getRouter().getEnergyCapacity() > 0 ? EnergyStatus.ENERGY_LOW : EnergyStatus.NO_UPGRADES);
            if (status != this.prevStatus) {
                this.setTooltip(status.getTooltip());
                this.prevStatus = status;
            }
            this.visible = status != EnergyStatus.OK;
        }

        public void playDownSound(SoundManager soundManager) {
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(240, Minecraft.getInstance().level.getGameTime() % 40L < 35L ? 0 : 240);
        }
    }

    private static enum EnergyStatus {
        OK(null),
        NO_UPGRADES(Tooltip.create((Component)ClientUtil.xlate("modularrouters.itemText.misc.energyWarning.noBuffer", new Object[0]).withStyle(ChatFormatting.GOLD))),
        ENERGY_LOW(Tooltip.create((Component)ClientUtil.xlate("modularrouters.itemText.misc.energyWarning", new Object[0]).withStyle(ChatFormatting.GOLD)));

        private final Tooltip tooltip;

        private EnergyStatus(Tooltip tooltip) {
            this.tooltip = tooltip;
        }

        public Tooltip getTooltip() {
            return this.tooltip;
        }
    }
}

