/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import com.klikli_dev.modonomicon.data.BookDataManager;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import org.commonmark.node.Link;
import org.commonmark.node.Node;

public class BookLinkRenderer
implements LinkRenderer {
    @Override
    public boolean visit(Link link, Consumer<Node> visitChildren, ComponentNodeRendererContext context) {
        if (BookLink.isBookLink(link.getDestination())) {
            TextColor currentColor = context.getCurrentStyle().getColor();
            BookErrorManager.get().setContext("Link: {}, \n{}", link.getDestination(), BookErrorManager.get().getContextHelper());
            try {
                BookLink bookLink = BookLink.from(context.getBook(), link.getDestination());
                Book book = BookDataManager.get().getBook(bookLink.bookId);
                MutableComponent goToText = Component.translatable((String)book.getName());
                if (bookLink.categoryId != null) {
                    BookCategory category = book.getCategory(bookLink.categoryId);
                    goToText = Component.translatable((String)category.getName());
                }
                if (bookLink.entryId != null) {
                    BookEntry entry = book.getEntry(bookLink.entryId);
                    goToText = Component.translatable((String)entry.getName());
                }
                MutableComponent hoverComponent = Component.translatable((String)"modonomicon.gui.hover.book_link", (Object[])new Object[]{goToText});
                context.setCurrentStyle(context.getCurrentStyle().withColor(currentColor == null ? context.getLinkColor() : currentColor).withClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, link.getDestination())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hoverComponent)));
                visitChildren.accept((Node)link);
                context.setCurrentStyle(context.getCurrentStyle().withColor(currentColor).withClickEvent(null).withHoverEvent(null));
            }
            catch (Exception e) {
                if (context.getBook().allowOpenBooksWithInvalidLinks()) {
                    Modonomicon.LOG.error("Failed to parse book link. allowOpenBooksWithInvalidLinks = true, so book parsing continues. Original error:", (Throwable)e);
                    MutableComponent hoverComponent = Component.translatable((String)"modonomicon.gui.hover.book_link.error", (Object[])new Object[]{link.getDestination()}).withStyle(ChatFormatting.RED);
                    context.setCurrentStyle(context.getCurrentStyle().withColor(ChatFormatting.RED).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hoverComponent)));
                    visitChildren.accept((Node)link);
                    context.setCurrentStyle(context.getCurrentStyle().withColor(currentColor).withClickEvent(null).withHoverEvent(null));
                }
                throw e;
            }
            BookErrorManager.get().setContext(null, new Object[0]);
            return true;
        }
        return false;
    }
}

