/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ReadAllButton
extends Button {
    public static final int U = 0;
    public static final int V_READ_UNLOCKED = 196;
    public static final int V_READ_ALL = 210;
    public static final int V_NONE = 224;
    public static final int WIDTH = 16;
    public static final int HEIGHT = 14;
    private final BookParentScreen parent;
    private final MutableComponent tooltipReadUnlocked;
    private final MutableComponent tooltipReadAll;
    private final MutableComponent tooltipNone;
    private final MutableComponent tooltipShiftInstructions;
    private final MutableComponent tooltipShiftWarning;
    private final Supplier<Boolean> displayCondition;
    private final Supplier<Boolean> hasUnreadUnlockedEntries;
    private boolean wasHovered;
    private int tooltipMsDelay;
    private long hoveredStartTime;

    public ReadAllButton(BookParentScreen parent, int x, int y, Supplier<Boolean> hasUnreadUnlockedEntries, Supplier<Boolean> displayCondition, Button.OnPress onPress) {
        super(x, y, 16, 14, (Component)Component.translatable((String)"modonomicon.gui.button.read_all"), onPress, Button.DEFAULT_NARRATION);
        this.parent = parent;
        this.tooltipReadUnlocked = Component.translatable((String)"modonomicon.gui.button.read_all.tooltip.read_unlocked");
        this.tooltipReadAll = Component.translatable((String)"modonomicon.gui.button.read_all.tooltip.read_all");
        this.tooltipNone = Component.translatable((String)"modonomicon.gui.button.read_all.tooltip.none");
        this.tooltipShiftInstructions = Component.translatable((String)"modonomicon.gui.button.read_all.tooltip.shift");
        this.tooltipShiftWarning = Component.translatable((String)"modonomicon.gui.button.read_all.tooltip.shift_warning");
        this.hasUnreadUnlockedEntries = hasUnreadUnlockedEntries;
        this.displayCondition = displayCondition;
    }

    public final void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.active = this.visible = this.displayCondition.get().booleanValue();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.updateCustomTooltip();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int v;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
        boolean hovered = this.isHovered();
        int u = 0;
        int n = v = this.hasUnreadUnlockedEntries.get() != false ? 196 : 224;
        if (hovered) {
            u += this.width;
        }
        if (Screen.hasShiftDown()) {
            v = 210;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(this.parent.getBook().getBookOverviewTexture(), this.getX(), this.getY(), (float)u, (float)v, this.width, this.height, 256, 256);
        guiGraphics.pose().popPose();
    }

    private void updateCustomTooltip() {
        boolean flag = this.isHovered();
        if (flag != this.wasHovered) {
            if (flag) {
                this.hoveredStartTime = Util.getMillis();
            }
            this.wasHovered = flag;
        }
        if (flag && Util.getMillis() - this.hoveredStartTime > (long)this.tooltipMsDelay) {
            MutableComponent tooltip = this.getCustomTooltip();
            Screen screen = ClientServices.GUI.getCurrentScreen();
            if (screen != null) {
                screen.setTooltipForNextRenderPass(Tooltip.create((Component)tooltip), DefaultTooltipPositioner.INSTANCE, this.isHovered());
            }
        }
    }

    public MutableComponent getCustomTooltip() {
        if (Screen.hasShiftDown()) {
            return Component.empty().append((Component)this.tooltipReadAll).append((Component)Component.literal((String)"\n\n")).append((Component)this.tooltipShiftWarning);
        }
        if (this.hasUnreadUnlockedEntries.get().booleanValue()) {
            return Component.empty().append((Component)this.tooltipReadUnlocked).append((Component)Component.literal((String)"\n\n")).append((Component)this.tooltipShiftInstructions);
        }
        return Component.empty().append((Component)this.tooltipNone).append((Component)Component.literal((String)"\n\n")).append((Component)this.tooltipShiftInstructions);
    }
}

